package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class RollCallPlanScheduledResponse extends ResponseAbstract {
    private long id;
    private int repetitiveRule;
    private String superviseDepartId;
    private Collection<String> stationTypes;
    private Collection<Integer> periodsOfTimes;

    private String actionOrgInstitutional;
    private String actionOrganizationId;
    private String actionOrganizationName;
    private String actionEmployeeId;
    private String actionEmployeeName;

    public RollCallPlanScheduledResponse() {

    }

    public Collection<Integer> getMatchedScheduledPlanTimes(int hourOfNow, Map<Long, Collection<Integer>> processedHourOfDayRollCallMap) {
        if (CollectionUtils.isEmpty(this.getPeriodsOfTimes())) {
            return Collections.EMPTY_LIST;
        }

        Collection<Integer> selectedPeriodOfTimes =
                this.periodsOfTimes.stream().filter(ix -> {
                            boolean flag = ix <= hourOfNow;
                            if (!flag) {
                                return false;
                            }

                            Collection<Integer> processedHourOfDay = processedHourOfDayRollCallMap.get(this.getId());
                            if (CollectionUtils.isEmpty(processedHourOfDay)) {
                                return true;
                            }

                            return processedHourOfDay.stream().anyMatch(dd -> dd == ix);
                        })
                        .collect(Collectors.toList());

        return selectedPeriodOfTimes;
    }

    public RollCallPlanScheduledResponse(long id,
                                         int repetitiveRule, String superviseDepartId,
                                         Collection<String> stationTypes,
                                         Collection<Time> periodsOfTimes,
                                         String actionOrganizationId,
                                         String actionOrgInstitutional,
                                         String actionOrganizationName,
                                         String actionEmployeeId,
                                         String actionEmployeeName) {
        this.id = id;
        this.repetitiveRule = repetitiveRule;
        this.superviseDepartId = superviseDepartId;
        this.stationTypes = stationTypes;
        this.actionOrganizationId = actionOrganizationId;
        this.actionOrganizationName = actionOrganizationName;
        this.actionEmployeeId = actionEmployeeId;
        this.actionEmployeeName = actionEmployeeName;
        this.actionOrgInstitutional = actionOrgInstitutional;

        if (!CollectionUtils.isEmpty(periodsOfTimes)) {
            SimpleDateFormat hourDateFormat = new SimpleDateFormat("HHmm");
            this.periodsOfTimes = periodsOfTimes.stream().map(ii -> {
                return Integer.parseInt(hourDateFormat.format(ii));
            }).collect(Collectors.toList());
        } else {
            this.periodsOfTimes = new HashSet<>();
        }
    }

    public static RollCallPlanScheduledResponse create(long id,
                                                       int repetitiveRule, String superviseDepartId,
                                                       Collection<String> stationTypes,
                                                       Collection<Time> periodsOfTimes,
                                                       String actionOrganizationId,
                                                       String actionOrgInstitutional,
                                                       String actionOrganizationName,
                                                       String actionEmployeeId,
                                                       String actionEmployeeName) {
        return new RollCallPlanScheduledResponse(
                id, repetitiveRule, superviseDepartId, stationTypes, periodsOfTimes,
                actionOrganizationId,
                actionOrgInstitutional,
                actionOrganizationName,
                actionEmployeeId,
                actionEmployeeName
        );
    }
}
