package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;

@Data
public class SyncUpdateGeoRequest extends UpdateGeoRequest{
    private Collection<String> employeeIds;
    private Timestamp timestamp;

    public SyncUpdateGeoRequest() {
        this.timestamp = Timestamp.from(Instant.now());
    }

    public static SyncUpdateGeoRequest create(UpdateGeoRequest request,Collection<String> employeeIds) {
        SyncUpdateGeoRequest syncUpdateGeoRequest = new SyncUpdateGeoRequest();
        if (!CollectionUtils.isEmpty(employeeIds)) {
            syncUpdateGeoRequest.setEmployeeIds(
                    employeeIds.stream()
                            .filter(ii -> !StringUtil.isEmpty(ii)
                            ).collect(Collectors.toList()));
        } else {
            syncUpdateGeoRequest.setEmployeeIds(employeeIds);
        }

        syncUpdateGeoRequest.setAddress(request.getAddress());
        syncUpdateGeoRequest.setLatitude(request.getLatitude());
        syncUpdateGeoRequest.setLongitude(request.getLongitude());

        return syncUpdateGeoRequest;
    }
}
