package com.bcxin.tenant.open.jdks.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;

@Schema(name = "BatchDeviceLocationRequest", title = "设备的批量经纬度信息")
@Data
public class BatchDeviceLocationRequest extends RequestAbstract {
    private Collection<DeviceLocationRequest> locations;

    public static BatchDeviceLocationRequest create(Collection<DeviceLocationRequest> locations) {
        BatchDeviceLocationRequest batchDeviceLocationRequest = new BatchDeviceLocationRequest();
        batchDeviceLocationRequest.setLocations(locations);

        return batchDeviceLocationRequest;
    }

    @Data
    public static class DeviceLocationRequest extends RequestAbstract {
        private String dispatchNo;
        private double lon;
        private double lat;
        private String senderUUId;
        private long createdTimeTick;

        public static DeviceLocationRequest create(String senderUUId,long createdTimeTick,String dispatchNo,double lon,double lat) {
            DeviceLocationRequest re = new DeviceLocationRequest();
            re.setDispatchNo(dispatchNo);
            re.setLat(lat);
            re.setLon(lon);
            re.setCreatedTimeTick(createdTimeTick);
            re.setSenderUUId(senderUUId);

            return re;
        }
    }
}
