/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.services.impls;

import cn.hutool.http.HttpResponse;
import com.bcxin.backend.core.AppConfigProperty;
import com.bcxin.backend.core.components.StorageProvider;
import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.SimpleLocalLockComponent;
import com.bcxin.backend.domain.enums.SyncType;
import com.bcxin.backend.domain.repositories.DomainSuperviseRepository;
import com.bcxin.backend.domain.syncs.components.HttpRequestProvider;
import com.bcxin.backend.domain.syncs.dtos.DataSyncParameter;
import com.bcxin.backend.domain.syncs.dtos.DbDataImportRequestDto;
import com.bcxin.backend.domain.syncs.dtos.SyncDataMeta;
import com.bcxin.backend.domain.syncs.dtos.SyncDataResponse;
import com.bcxin.backend.domain.syncs.dtos.SyncDataSetDTO;
import com.bcxin.backend.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.backend.domain.syncs.services.DataSyncQueueService;
import com.bcxin.backend.domain.syncs.services.impls.DataSyncQueueServiceBase;
import com.bcxin.runtime.domain.snapshoots.FormSyncTargetConfigSnapshot;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus;
import com.bcxin.saas.core.components.JsonProvider;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service(value="DataSyncQueueServiceImpl")
public class DataSyncQueueServiceImpl
extends DataSyncQueueServiceBase
implements DataSyncQueueService {
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DataSyncQueueServiceImpl(DataSyncQueueRepository dataSyncQueueRepository, JsonProvider jsonProvider, HttpRequestProvider httpRequestProvider, AppConfigProperty appConfigProperty, StorageProvider storageProvider, DomainSuperviseRepository domainSuperviseRepository, SimpleLocalLockComponent simpleLocalLockComponent) {
        super(dataSyncQueueRepository, jsonProvider, httpRequestProvider, appConfigProperty, storageProvider, domainSuperviseRepository, simpleLocalLockComponent);
    }

    @Override
    public void dispatchData() {
        this.dispatch(SyncType.DirectlyData);
    }

    @Override
    public void dispatchFile() {
        this.dispatch(SyncType.DirectlyFile);
    }

    private SyncDataMeta saveNormalRequestData(DbDataImportRequestDto dataImportRequestDto, boolean isData) {
        String path = String.format("/uploads/sync/response/normal/%s/%s-%s.txt", isData ? "data" : "files", simpleDateFormat.format(new Date()), UUID.randomUUID());
        String data = this.jsonProvider.getJson((Object)dataImportRequestDto);
        byte[] content = data.getBytes(StandardCharsets.UTF_8);
        String realPath = this.storageProvider.save(path, content);
        return SyncDataMeta.create(path, content.length, realPath, Collections.EMPTY_LIST);
    }

    @Override
    protected void executeSyncFileCore(DataSyncParameter dataSyncParameter) {
        this.executeSyncDataCore(dataSyncParameter);
    }

    @Override
    protected void executeSyncDataCore(DataSyncParameter dataSyncParameter) {
        DataSyncQueueEntity data = dataSyncParameter.getDataSyncQueueEntity();
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(String.format("%s: \u6b63\u5728\u6267\u884c: DataSyncQueueServiceImpl.dispatchData:%s", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()), dataSyncParameter.getDataSyncQueueEntity().getId()));
            FormSyncTargetConfigSnapshot formSyncTargetConfig = dataSyncParameter.getFormSyncTargetConfig();
            String url = formSyncTargetConfig.getUrl();
            sb.append("\uff1b\u5f00\u59cb\u83b7\u53d6this.jsonProvider.getData(getSyncRealData(data), DataSetDto.class)");
            SyncDataSetDTO syncDataSetDTO = (SyncDataSetDTO)this.jsonProvider.getData(this.getSyncRealData(data), SyncDataSetDTO.class);
            DataSetDto dataSetDto = syncDataSetDTO.getDataSetDto();
            DbDataImportRequestDto.DataSet dbDataSet = DbDataImportRequestDto.DataSet.create(data.getId(), dataSyncParameter.getMapKey(), dataSetDto.getRows(), dataSetDto.getDeletedIds());
            sb.append("\uff1b\u5f00\u59cb\u83b7\u53d6DbDataImportRequestDto.create(Collections.singleton(dbDataSet))");
            DbDataImportRequestDto requestDto = DbDataImportRequestDto.create(data.getData(), Collections.singleton(dbDataSet));
            SyncDataResponse syncDataResponse = SyncDataResponse.create(url, formSyncTargetConfig.getHeaders(), "\u6682\u4e0d\u5b58\u50a8\u8bf7\u6c42\u53c2\u6570");
            sb.append("\uff1b\u5f00\u59cb\u63a8\u9001Post\u8bf7\u6c42\uff1a  this.httpRequestProvider.post(syncDataResponse.getRequestUrl()");
            HttpResponse result = this.httpRequestProvider.post(url, syncDataResponse.getRequestHeaders(), this.jsonProvider.getJson((Object)requestDto));
            sb.append(String.format("\uff1b\u54cd\u5e94\u7ed3\u679c\u72b6\u6001\u4e3a\uff1a  %s; \u7ed3\u679c:%s", result.getStatus(), result.body()));
            syncDataResponse.assign(result.getStatus(), result.body());
            if (result.getStatus() >= 200 && result.getStatus() < 300) {
                data.changeDataSyncStatus(SyncProcessStatus.Done, this.jsonProvider.getJson((Object)syncDataResponse));
            } else {
                data.changeDataSyncStatus(SyncProcessStatus.Error, this.jsonProvider.getJson((Object)syncDataResponse));
            }
            sb.append(String.format("%s:\u5f02\u5e38: DataSyncQueueServiceImpl.dispatchData:url=%s; \u54cd\u5e94\u72b6\u6001=%s; \u8be6\u7ec6= %s", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()), url, result.getStatus(), data.getResult()));
            this.printBusinessMsg(sb.toString());
        }
        catch (Exception ex) {
            String msg = String.format("%s:\u5f02\u5e38: DataSyncQueueServiceImpl.dispatchData:\u3010\u8ddf\u8e2a\uff1a%s\u3011%s; \u8be6\u7ec6: %s", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()), sb, dataSyncParameter.getDataSyncQueueEntity().getId(), ExceptionUtils.getStackMessage((Throwable)ex));
            logger.error(msg);
            throw new SaasBadException(msg, ex);
        }
    }

    @Override
    protected boolean isMatchExecuteCondition(boolean isDispatchFile, DataSyncQueueEntity data) {
        return (data.getStatus() == SyncProcessStatus.Initialize && !isDispatchFile || data.getFileSyncStatus() == SyncProcessStatus.Initialize && isDispatchFile) && super.isMatchExecuteCondition(isDispatchFile, data);
    }
}

