/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.auth.service.impl;

import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.domain.auth.dtos.AuthLog;
import com.bcxin.backend.domain.auth.dtos.AuthRequestDto;
import com.bcxin.backend.domain.auth.factory.AuthFactory;
import com.bcxin.backend.domain.models.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public abstract class AuthenticationServiceAbstractImpl {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationServiceAbstractImpl.class);
    private static Logger logger = LoggerFactory.getLogger(AuthenticationServiceAbstractImpl.class);
    private final AuthFactory authFactory;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;

    public AuthenticationServiceAbstractImpl(AuthFactory authFactory) {
        this.authFactory = authFactory;
    }

    public abstract String findUnAuthSql();

    public Boolean auth() {
        logger.info("-----------------------------------------------\u5b9e\u540d\u8ba4\u8bc1\u7a0b\u5e8f\u5f00\u59cb\u6267\u884c--------------------------------------------------------------");
        try {
            List<AuthRequestDto> authRequestDtos = this.getPendingBgScreenUsers();
            logger.info("\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u5f85\u8ba4\u8bc1\u4eba\u5458\u6761\u6570:{};\u8be6\u60c5=[{}]", (Object)authRequestDtos.size(), (Object)authRequestDtos.stream().map(ii -> String.format("'%s'", ii.getIdNumber())).collect(Collectors.joining(",")));
            if (!CollectionUtils.isEmpty(authRequestDtos)) {
                ArrayList pageAuthRequests = new ArrayList();
                ArrayList<AuthRequestDto> perPageAuthRequests = null;
                for (int index = 0; index < authRequestDtos.size(); ++index) {
                    if (index % 10 == 0) {
                        perPageAuthRequests = new ArrayList<AuthRequestDto>();
                        pageAuthRequests.add(perPageAuthRequests);
                    }
                    perPageAuthRequests.add(authRequestDtos.get(index));
                }
                pageAuthRequests.parallelStream().forEach(limitAuthUsers -> {
                    Exception lastException = null;
                    try {
                        this.check((List<AuthRequestDto>)limitAuthUsers);
                    }
                    catch (Exception e) {
                        try {
                            lastException = e;
                        }
                        catch (Throwable throwable) {
                            logger.error("{}:\u5b8c\u6210\u6267\u884c\u5b9e\u540d\u8ba4\u8bc1--\u5f85\u8ba4\u8bc1\u7684\u4eba\u5458:{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", limitAuthUsers.stream().map(ii -> String.format("'%s'", ii.getIdNumber())).collect(Collectors.joining(",")), lastException});
                            throw throwable;
                        }
                        logger.error("{}:\u5b8c\u6210\u6267\u884c\u5b9e\u540d\u8ba4\u8bc1--\u5f85\u8ba4\u8bc1\u7684\u4eba\u5458:{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", limitAuthUsers.stream().map(ii -> String.format("'%s'", ii.getIdNumber())).collect(Collectors.joining(",")), lastException});
                    }
                    logger.error("{}:\u5b8c\u6210\u6267\u884c\u5b9e\u540d\u8ba4\u8bc1--\u5f85\u8ba4\u8bc1\u7684\u4eba\u5458:{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", limitAuthUsers.stream().map(ii -> String.format("'%s'", ii.getIdNumber())).collect(Collectors.joining(",")), lastException});
                });
                return true;
            }
            logger.info("\u88ab\u7b5b\u4eba\u5458\u5217\u8868\u4e3a\u7a7a");
            return false;
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5b9e\u540d\u8ba4\u8bc1\u65b9\u6cd5-\u53d1\u751f\u5f02\u5e38:{}", (Throwable)e);
            return false;
        }
    }

    private List<AuthRequestDto> getPendingBgScreenUsers() {
        String sql = this.findUnAuthSql();
        logger.info("\u5f85\u67e5\u8be2\u7684\u4eba\u5458SQL={}", (Object)sql);
        return this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(AuthRequestDto.class));
    }

    private Result<List<AuthLog>> doExecute(Collection<AuthRequestDto> authRequestDtos) {
        return this.authFactory.getAuthByType().auth(authRequestDtos);
    }

    protected void check(List<AuthRequestDto> authRequestDtos) {
        block5: {
            try {
                Result<List<AuthLog>> result = this.doExecute(authRequestDtos);
                if ("0".equals(result.getRetType())) {
                    if (result.getData() == null) {
                        throw new SaasBadException(String.format("AuthenticationServiceAbstractImpl:Request interface message returns exception,ErrMsg:%s.", result.getMsg()));
                    }
                    List<AuthLog> list = result.getData();
                    if (list.size() > 0) {
                        this.updateAuthResult(list);
                        logger.info("\u8ba4\u8bc1\u7ed3\u679c\u4e3a:{}", (Object)list.stream().map(ii -> String.format("\u8eab\u4efd\u8bc1=%s;\u7ed3\u679c=%s", ii.getIdNumber(), ii.getAuthResult())).collect(Collectors.joining(";")));
                    }
                    break block5;
                }
                throw new SaasBadException(String.format("AuthenticationServiceAbstractImpl:Request interface failed,ErrMsg:%s.", result.getMsg()));
            }
            catch (Exception e) {
                logger.error("\u5b9e\u540d\u8ba4\u8bc1\u51fa\u73b0\u5f02\u5e38:\u4eba\u5458={}", (Object)authRequestDtos.stream().map(ii -> ii.getIdNumber()).collect(Collectors.joining(",")), (Object)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Transactional(rollbackFor={Exception.class})
    public void updateAuthResult(List<AuthLog> authlogs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

