/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.CouponConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.coupon.Coupon;
import com.zbkj.common.model.coupon.CouponUser;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CouponUserSearchRequest;
import com.zbkj.common.request.MyCouponRequest;
import com.zbkj.common.request.OrderUseCouponRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.CouponUserOrderResponse;
import com.zbkj.common.response.CouponUserResponse;
import com.zbkj.common.response.UserCouponResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.PreMerchantOrderVo;
import com.zbkj.common.vo.PreOrderInfoDetailVo;
import com.zbkj.common.vo.PreOrderInfoVo;
import com.zbkj.service.dao.CouponUserDao;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.ProductCategoryService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CouponUserServiceImpl
extends ServiceImpl<CouponUserDao, CouponUser>
implements CouponUserService {
    @Resource
    private CouponUserDao dao;
    private final Logger logger = LoggerFactory.getLogger(CouponUserServiceImpl.class);
    @Autowired
    private CouponService couponService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductCategoryService productCategoryService;

    @Override
    public Boolean useBatch(List<Integer> couponIdList) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_USED);
        wrapper.set(CouponUser::getUseTime, (Object)DateUtil.date());
        wrapper.in(CouponUser::getId, couponIdList);
        wrapper.eq(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<CouponUserResponse> getPageList(CouponUserSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page CouponUserPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getMerId, (Object)systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String couponName = URLUtil.decode((String)request.getName());
            lqw.like(CouponUser::getName, (Object)couponName);
        }
        if (ObjectUtil.isNotNull((Object)request.getUid()) && request.getUid() > 0) {
            lqw.eq(CouponUser::getUid, (Object)request.getUid());
        }
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(CouponUser::getStatus, (Object)request.getStatus());
        }
        lqw.orderByDesc(CouponUser::getId);
        List couponUserList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponUserList)) {
            return new PageInfo();
        }
        List<Integer> uidList = couponUserList.stream().map(CouponUser::getUid).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        ArrayList<CouponUserResponse> CouponUserResponseList = new ArrayList<CouponUserResponse>();
        for (CouponUser CouponUser2 : couponUserList) {
            CouponUserResponse CouponUserResponse2 = new CouponUserResponse();
            BeanUtils.copyProperties((Object)CouponUser2, (Object)CouponUserResponse2);
            if (userMap.containsKey(CouponUser2.getUid())) {
                CouponUserResponse2.setNickname(userMap.get(CouponUser2.getUid()).getNickname());
                CouponUserResponse2.setAvatar(userMap.get(CouponUser2.getUid()).getAvatar());
            }
            CouponUserResponseList.add(CouponUserResponse2);
        }
        return CommonPage.copyPageInfo((Page)CouponUserPage, CouponUserResponseList);
    }

    private void filterReceiveUserInUid(Integer couponId, List<Integer> uidList) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getCouponId, (Object)couponId);
        lqw.in(CouponUser::getUid, uidList);
        List CouponUserList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isNotEmpty((Collection)CouponUserList)) {
            List receiveUidList = CouponUserList.stream().map(CouponUser::getUid).distinct().collect(Collectors.toList());
            uidList.removeAll(receiveUidList);
        }
    }

    @Override
    public HashMap<Integer, CouponUser> getMapByUserId(Integer userId) {
        List<CouponUser> list = this.findListByUid(userId);
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        HashMap<Integer, CouponUser> map = new HashMap<Integer, CouponUser>();
        for (CouponUser info : list) {
            map.put(info.getCouponId(), info);
        }
        return map;
    }

    private List<CouponUser> findListByUid(Integer uid) {
        LambdaQueryWrapper lwq = new LambdaQueryWrapper();
        lwq.eq(CouponUser::getUid, (Object)uid);
        return this.dao.selectList((Wrapper)lwq);
    }

    @Override
    public List<CouponUserOrderResponse> getListByPreOrderNo(OrderUseCouponRequest request) {
        String key = "user_pre_order:" + request.getPreOrderNo();
        boolean exists = this.redisUtil.exists(key);
        if (!exists) {
            throw new CrmebException("\u9884\u4e0b\u5355\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String orderVoString = this.redisUtil.get(key).toString();
        PreOrderInfoVo preOrderInfoVo = (PreOrderInfoVo)JSONObject.parseObject((String)orderVoString, PreOrderInfoVo.class);
        Integer uid = this.userService.getUserIdException();
        if (request.getMerId() > 0) {
            List pidList = null;
            BigDecimal maxPrice = BigDecimal.ZERO;
            for (PreMerchantOrderVo merchantOrderVo : preOrderInfoVo.getMerchantOrderVoList()) {
                if (!merchantOrderVo.getMerId().equals(request.getMerId())) continue;
                pidList = merchantOrderVo.getOrderInfoList().stream().map(PreOrderInfoDetailVo::getProductId).distinct().collect(Collectors.toList());
                maxPrice = merchantOrderVo.getProTotalFee();
            }
            String pidPrimaryKeySql = this.getPidPrimaryKeySql(pidList);
            Date date = CrmebDateUtil.nowDateTime();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("merId", request.getMerId());
            map.put("maxPrice", maxPrice);
            map.put("date", date);
            map.put("uid", uid);
            map.put("pidPrimaryKeySql", pidPrimaryKeySql);
            return this.dao.findListByPreOrder(map);
        }
        ArrayList orderInfoList = new ArrayList();
        ArrayList<Integer> merIdList = new ArrayList<Integer>();
        for (PreMerchantOrderVo merchantOrderVo : preOrderInfoVo.getMerchantOrderVoList()) {
            orderInfoList.addAll(merchantOrderVo.getOrderInfoList());
            merIdList.add(merchantOrderVo.getMerId());
        }
        List<Integer> proIdsList = orderInfoList.stream().map(PreOrderInfoDetailVo::getProductId).distinct().collect(Collectors.toList());
        BigDecimal price = preOrderInfoVo.getProTotalFee();
        List<Product> productList = this.productService.findByIds(proIdsList);
        List<Integer> proCategoryIdList = productList.stream().map(Product::getCategoryId).collect(Collectors.toList());
        List<Integer> secondParentIdList = this.productCategoryService.findParentIdByChildIds(proCategoryIdList);
        List<Integer> firstParentIdList = this.productCategoryService.findParentIdByChildIds(secondParentIdList);
        proCategoryIdList.addAll(secondParentIdList);
        proCategoryIdList.addAll(firstParentIdList);
        List<Integer> brandIdList = productList.stream().map(Product::getBrandId).collect(Collectors.toList());
        List<CouponUser> platCouponUserList = this.findManyPlatByUidAndMerIdAndMoneyAndProList(uid, proIdsList, proCategoryIdList, merIdList, brandIdList, price);
        return platCouponUserList.stream().map(e -> {
            CouponUserOrderResponse response = new CouponUserOrderResponse();
            BeanUtils.copyProperties((Object)e, (Object)response);
            return response;
        }).collect(Collectors.toList());
    }

    private String getPidPrimaryKeySql(List<Integer> pidList) {
        ArrayList sqlList = new ArrayList();
        pidList.forEach(pid -> {
            String sql = pid + " in (select pid from eb_coupon_product where cid = cu.coupon_id)";
            sqlList.add(sql);
        });
        return "( " + StringUtils.join(sqlList, (String)" or ") + ")";
    }

    @Override
    public void overdueTask() {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        List couponList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponList)) {
            this.logger.info("\u6279\u91cf\u66f4\u65b0\u4f18\u60e0\u5238\u8fc7\u671f\u65e0\u53ef\u66f4\u65b0\u4f18\u60e0\u5238,\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)DateUtil.date());
            return;
        }
        ArrayList idList = CollUtil.newArrayList((Object[])new Integer[0]);
        DateTime nowDate = DateUtil.date();
        for (CouponUser couponUser : couponList) {
            if (!ObjectUtil.isNotNull((Object)couponUser.getEndTime()) || DateUtil.between((Date)nowDate, (Date)couponUser.getEndTime(), (DateUnit)DateUnit.SECOND, (boolean)false) > 0L) continue;
            idList.add(couponUser.getId());
        }
        if (CollUtil.isEmpty((Collection)idList)) {
            this.logger.info("\u6279\u91cf\u66f4\u65b0\u4f18\u60e0\u5238\u8fc7\u671f\u65e0\u53ef\u7528 \u7528\u6237\u4f18\u60e0\u5238id,\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)DateUtil.date());
            return;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_LAPSED);
        wrapper.in(CouponUser::getId, (Collection)idList);
        wrapper.eq(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        boolean update = this.update((Wrapper)wrapper);
        if (!update) {
            this.logger.error("\u6279\u91cf\u66f4\u65b0\u4f18\u60e0\u5238\u8fc7\u671f\u52a8\u4f5c\u5931\u8d25,\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)DateUtil.date());
        }
    }

    @Override
    public Boolean receiveCoupon(Integer cid) {
        String date;
        int result;
        Integer userId = this.userService.getUserIdException();
        Coupon coupon = this.couponService.getInfoException(cid);
        if (!coupon.getStatus().booleanValue()) {
            throw new CrmebException("\u4f18\u60e0\u5238\u72b6\u6001\u5f02\u5e38");
        }
        if (coupon.getIsLimited().booleanValue() && coupon.getLastTotal() < 1) {
            throw new CrmebException("\u4f18\u60e0\u5238\u4f59\u91cf\u4e0d\u8db3\uff01");
        }
        if (coupon.getIsTimeReceive().booleanValue() && (result = CrmebDateUtil.compareDate((String)(date = CrmebDateUtil.nowDateTimeStr()), (String)CrmebDateUtil.dateToStr((Date)coupon.getReceiveEndTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss")) > 0) {
            throw new CrmebException("\u4f18\u60e0\u5238\u9886\u53d6\u622a\u6b62\u65e5\u671f\u5df2\u8fc7\uff01");
        }
        if (!this.userIsCanReceiveCoupon(coupon, userId).booleanValue()) {
            throw new CrmebException("\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u9886\u53d6\u8fc7\u6b64\u4f18\u60e0\u5238\u4e86\uff01");
        }
        if (!coupon.getIsFixedTime().booleanValue()) {
            String endTime = CrmebDateUtil.addDay((String)CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"), (int)coupon.getDay(), (String)"yyyy-MM-dd HH:mm:ss");
            coupon.setUseEndTime(CrmebDateUtil.strToDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
            coupon.setUseStartTime(CrmebDateUtil.nowDateTimeReturnDate((String)"yyyy-MM-dd HH:mm:ss"));
        }
        CouponUser couponUser = new CouponUser();
        couponUser.setCouponId(coupon.getId());
        couponUser.setMerId(coupon.getMerId());
        couponUser.setUid(userId);
        couponUser.setName(coupon.getName());
        couponUser.setPublisher(coupon.getPublisher());
        couponUser.setCategory(coupon.getCategory());
        couponUser.setReceiveType(coupon.getReceiveType());
        couponUser.setCouponType(coupon.getCouponType());
        couponUser.setMoney(coupon.getMoney());
        couponUser.setDiscount(coupon.getDiscount());
        couponUser.setMinPrice(coupon.getMinPrice());
        couponUser.setStartTime(coupon.getUseStartTime());
        couponUser.setEndTime(coupon.getUseEndTime());
        couponUser.setStatus(CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.save(couponUser);
            this.couponService.deduction(coupon.getId(), 1, coupon.getIsLimited());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean userIsCanReceiveCoupon(Coupon coupon, Integer userId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getCouponId, (Object)coupon.getId());
        lqw.eq(CouponUser::getUid, (Object)userId);
        lqw.orderByDesc(CouponUser::getId);
        lqw.last(" limit 1");
        CouponUser couponUser = (CouponUser)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)couponUser)) {
            return true;
        }
        if (!coupon.getIsRepeated().booleanValue()) {
            return false;
        }
        if (!couponUser.getStatus().equals(CouponConstants.STORE_COUPON_USER_STATUS_USABLE)) {
            return true;
        }
        return false;
    }

    private Boolean isUserReceiveCoupon(Integer couponId, Integer userId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getCouponId, (Object)couponId);
        lqw.eq(CouponUser::getUid, (Object)userId);
        lqw.last(" limit 1");
        CouponUser couponUser = (CouponUser)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)couponUser);
    }

    @Override
    public MyRecord paySuccessGiveAway(Integer couponId, Integer uid) {
        String date;
        int result;
        MyRecord record = new MyRecord();
        record.set("status", (Object)"fail");
        Coupon coupon = (Coupon)this.couponService.getById(couponId);
        if (ObjectUtil.isNull((Object)coupon) || coupon.getIsDel().booleanValue() || !coupon.getStatus().booleanValue()) {
            record.set("errMsg", (Object)"\u4f18\u60e0\u5238\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u5931\u6548\uff01");
            return record;
        }
        if (ObjectUtil.isNotNull((Object)coupon.getReceiveStartTime()) && (result = CrmebDateUtil.compareDate((String)(date = CrmebDateUtil.nowDateTimeStr()), (String)CrmebDateUtil.dateToStr((Date)coupon.getReceiveStartTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss")) == -1) {
            record.set("errMsg", (Object)"\u8fd8\u672a\u8fbe\u5230\u4f18\u60e0\u5238\u9886\u53d6\u65f6\u95f4\uff01");
            return record;
        }
        if (coupon.getReceiveEndTime() != null && (result = CrmebDateUtil.compareDate((String)(date = CrmebDateUtil.nowDateTimeStr()), (String)CrmebDateUtil.dateToStr((Date)coupon.getReceiveEndTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss")) == 1) {
            record.set("errMsg", (Object)"\u5df2\u8d85\u8fc7\u4f18\u60e0\u5238\u9886\u53d6\u6700\u540e\u671f\u9650\uff01");
            return record;
        }
        if (coupon.getIsLimited().booleanValue() && coupon.getLastTotal() < 1) {
            record.set("errMsg", (Object)"\u6b64\u4f18\u60e0\u5238\u5df2\u7ecf\u88ab\u9886\u5b8c\u4e86\uff01");
            return record;
        }
        ArrayList uidList = CollUtil.newArrayList((Object[])new Integer[0]);
        uidList.add(uid);
        this.filterReceiveUserInUid(coupon.getId(), uidList);
        if (uidList.size() < 1) {
            record.set("errMsg", (Object)"\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u9886\u53d6\u8fc7\u6b64\u4f18\u60e0\u5238\u4e86\uff01");
            return record;
        }
        if (!coupon.getIsFixedTime().booleanValue()) {
            String endTime = CrmebDateUtil.addDay((String)CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"), (int)coupon.getDay(), (String)"yyyy-MM-dd HH:mm:ss");
            coupon.setUseEndTime(CrmebDateUtil.strToDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
            coupon.setUseStartTime(CrmebDateUtil.nowDateTimeReturnDate((String)"yyyy-MM-dd HH:mm:ss"));
        }
        CouponUser couponUser = new CouponUser();
        couponUser.setCouponId(coupon.getId());
        couponUser.setMerId(coupon.getMerId());
        couponUser.setUid(uid);
        couponUser.setName(coupon.getName());
        couponUser.setPublisher(coupon.getPublisher());
        couponUser.setCategory(coupon.getCategory());
        couponUser.setReceiveType(coupon.getReceiveType());
        couponUser.setCouponType(coupon.getCouponType());
        couponUser.setMoney(coupon.getMoney());
        couponUser.setDiscount(coupon.getDiscount());
        couponUser.setMinPrice(coupon.getMinPrice());
        couponUser.setStatus(CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        if (!coupon.getIsFixedTime().booleanValue()) {
            String endTime = CrmebDateUtil.addDay((String)CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"), (int)coupon.getDay(), (String)"yyyy-MM-dd HH:mm:ss");
            couponUser.setStartTime(CrmebDateUtil.nowDateTimeReturnDate((String)"yyyy-MM-dd HH:mm:ss"));
            couponUser.setEndTime(CrmebDateUtil.strToDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            couponUser.setStartTime(coupon.getUseStartTime());
            couponUser.setEndTime(coupon.getUseEndTime());
        }
        record.set("status", (Object)"ok");
        record.set("couponUser", (Object)couponUser);
        record.set("isLimited", (Object)coupon.getIsLimited());
        return record;
    }

    @Override
    public Integer getUseCount(Integer uid) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getUid, (Object)uid);
        lqw.eq(CouponUser::getStatus, (Object)0);
        List couponUserList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponUserList)) {
            return 0;
        }
        Date date = CrmebDateUtil.nowDateTime();
        int i = 0;
        while (i < couponUserList.size()) {
            CouponUser couponUser = (CouponUser)couponUserList.get(i);
            if (ObjectUtil.isNotNull((Object)couponUser.getStartTime()) && ObjectUtil.isNotNull((Object)couponUser.getEndTime()) && date.compareTo(couponUser.getEndTime()) >= 0) {
                couponUserList.remove(i);
                continue;
            }
            ++i;
        }
        return CollUtil.isEmpty((Collection)couponUserList) ? 0 : couponUserList.size();
    }

    @Override
    public PageInfo<UserCouponResponse> getMyCouponList(MyCouponRequest request) {
        Integer userId = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CouponUser::getUid, (Object)userId);
        if (request.getType().equals("usable")) {
            lqw.eq(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
            lqw.orderByDesc(CouponUser::getId);
        }
        if (request.getType().equals("unusable")) {
            lqw.gt(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
            lqw.last(StrUtil.format((CharSequence)" order by update_time desc, id desc, case `status` when {} then {} when {} then {} when {} then {} end, update_time desc, id desc", (Object[])new Object[]{0, 1, 1, 2, 2, 3}));
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List couponUserList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponUserList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new UserCouponResponse[0]));
        }
        Date date = CrmebDateUtil.nowDateTime();
        ArrayList responseList = CollUtil.newArrayList((Object[])new UserCouponResponse[0]);
        for (CouponUser couponUser : couponUserList) {
            UserCouponResponse userCouponResponse = new UserCouponResponse();
            BeanUtils.copyProperties((Object)couponUser, (Object)userCouponResponse);
            String validStr = "usable";
            if (couponUser.getStatus().equals(CouponConstants.STORE_COUPON_USER_STATUS_USED)) {
                validStr = "unusable";
            }
            if (couponUser.getStatus().equals(CouponConstants.STORE_COUPON_USER_STATUS_LAPSED)) {
                validStr = "overdue";
            }
            if (ObjectUtil.isNotNull((Object)userCouponResponse.getStartTime()) && ObjectUtil.isNotNull((Object)userCouponResponse.getEndTime())) {
                if (userCouponResponse.getStartTime().compareTo(date) > 0) {
                    validStr = "notStart";
                }
                if (date.compareTo(userCouponResponse.getEndTime()) >= 0) {
                    validStr = "overdue";
                }
            }
            userCouponResponse.setValidStr(validStr);
            responseList.add(userCouponResponse);
        }
        return CommonPage.copyPageInfo((Page)page, (List)responseList);
    }

    @Override
    public Boolean rollbackByIds(List<Integer> couponIdList) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        wrapper.in(CouponUser::getId, couponIdList);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean loseEfficacyByCouponId(Integer couponId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_LAPSED);
        wrapper.eq(CouponUser::getCouponId, (Object)couponId);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Integer getUsedNumByCouponId(Integer couponId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getCouponId, (Object)couponId);
        lqw.eq(CouponUser::getStatus, (Object)CouponConstants.STORE_COUPON_USER_STATUS_USED);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public List<CouponUser> findByCouponIdAndUidList(Integer couponId, List<Integer> uidList) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getCouponId, (Object)couponId);
        lqw.in(CouponUser::getUid, uidList);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<CouponUserResponse> getPlatformList(CouponUserSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getPublisher, (Object)CouponConstants.COUPON_PUBLISHER_PLATFORM);
        lqw.eq(CouponUser::getMerId, (Object)0);
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String couponName = URLUtil.decode((String)request.getName());
            lqw.like(CouponUser::getName, (Object)couponName);
        }
        if (ObjectUtil.isNotNull((Object)request.getUid()) && request.getUid() > 0) {
            lqw.eq(CouponUser::getUid, (Object)request.getUid());
        }
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(CouponUser::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getNickname())) {
            String decodeName = URLUtil.decode((String)request.getNickname());
            lqw.apply(StrUtil.format((CharSequence)"(uid in (select id from eb_user where nickname like '%{}%'))", (Object[])new Object[]{decodeName}), new Object[0]);
        }
        lqw.orderByDesc(CouponUser::getId);
        List couponUserList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponUserList)) {
            return new PageInfo();
        }
        List<Integer> uidList = couponUserList.stream().map(CouponUser::getUid).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        ArrayList<CouponUserResponse> CouponUserResponseList = new ArrayList<CouponUserResponse>();
        for (CouponUser CouponUser2 : couponUserList) {
            CouponUserResponse CouponUserResponse2 = new CouponUserResponse();
            BeanUtils.copyProperties((Object)CouponUser2, (Object)CouponUserResponse2);
            if (userMap.containsKey(CouponUser2.getUid())) {
                CouponUserResponse2.setNickname(userMap.get(CouponUser2.getUid()).getNickname());
                CouponUserResponse2.setAvatar(userMap.get(CouponUser2.getUid()).getAvatar());
            }
            CouponUserResponseList.add(CouponUserResponse2);
        }
        return CommonPage.copyPageInfo((Page)page, CouponUserResponseList);
    }

    @Override
    public CouponUser getLastByCouponIdAndUid(Integer couponId, Integer userId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CouponUser::getCouponId, (Object)couponId);
        lqw.eq(CouponUser::getUid, (Object)userId);
        lqw.orderByDesc(CouponUser::getId);
        lqw.last(" limit 1");
        return (CouponUser)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<CouponUser> findByUidAndMerIdAndMoneyAndProList(Integer userId, Integer merId, Integer proId, BigDecimal money) {
        String now = DateUtil.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("merId", merId);
        map.put("proId", proId);
        map.put("money", money);
        map.put("nowDate", now);
        return this.dao.findByUidAndMerIdAndMoneyAndProList(map);
    }

    @Override
    public Integer autoReceiveCoupon(Coupon coupon, Integer uid) {
        if (!coupon.getIsFixedTime().booleanValue()) {
            String endTime = CrmebDateUtil.addDay((String)CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"), (int)coupon.getDay(), (String)"yyyy-MM-dd HH:mm:ss");
            coupon.setUseEndTime(CrmebDateUtil.strToDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
            coupon.setUseStartTime(CrmebDateUtil.nowDateTimeReturnDate((String)"yyyy-MM-dd HH:mm:ss"));
        }
        CouponUser couponUser = new CouponUser();
        couponUser.setCouponId(coupon.getId());
        couponUser.setMerId(coupon.getMerId());
        couponUser.setUid(uid);
        couponUser.setName(coupon.getName());
        couponUser.setPublisher(coupon.getPublisher());
        couponUser.setCategory(coupon.getCategory());
        couponUser.setReceiveType(coupon.getReceiveType());
        couponUser.setCouponType(coupon.getCouponType());
        couponUser.setMoney(coupon.getMoney());
        couponUser.setDiscount(coupon.getDiscount());
        couponUser.setMinPrice(coupon.getMinPrice());
        couponUser.setStartTime(coupon.getUseStartTime());
        couponUser.setEndTime(coupon.getUseEndTime());
        couponUser.setStatus(CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.save(couponUser);
            this.couponService.deduction(coupon.getId(), 1, coupon.getIsLimited());
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u81ea\u52a8\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25");
        }
        return couponUser.getId();
    }

    @Override
    public List<CouponUser> findPlatByUidAndMerIdAndMoneyAndProList(Integer userId, Integer proId, List<Integer> proCategoryIdList, Integer merId, Integer brandId, BigDecimal money) {
        String now = DateUtil.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("proId", proId);
        map.put("proCategoryIdList", proCategoryIdList);
        map.put("merId", merId);
        map.put("brandId", brandId);
        map.put("money", money);
        map.put("nowDate", now);
        return this.dao.findPlatByUidAndMerIdAndMoneyAndProList(map);
    }

    @Override
    public List<CouponUser> findManyByUidAndMerIdAndMoneyAndProList(Integer userId, Integer merId, List<Integer> proIdList, BigDecimal money) {
        String now = DateUtil.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("merId", merId);
        map.put("proIdList", proIdList);
        map.put("money", money);
        map.put("nowDate", now);
        return this.dao.findManyByUidAndMerIdAndMoneyAndProList(map);
    }

    @Override
    public List<CouponUser> findManyPlatByUidAndMerIdAndMoneyAndProList(Integer userId, List<Integer> proIdList, List<Integer> proCategoryIdList, List<Integer> merIdList, List<Integer> brandIdList, BigDecimal money) {
        String now = DateUtil.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("proIdList", proIdList);
        map.put("proCategoryIdList", proCategoryIdList);
        map.put("merIdList", merIdList);
        map.put("brandIdList", brandIdList);
        map.put("money", money);
        map.put("nowDate", now);
        return this.dao.findManyPlatByUidAndMerIdAndMoneyAndProList(map);
    }
}

