/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities.valueTypes;

import com.bcxin.Infrastructures.entities.ValueType;
import com.bcxin.tenant.domain.entities.valueTypes.ItemValueType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class LocationValueType
extends ValueType {
    @Column(length=50, name="provider")
    private ItemValueType province;
    @Column(length=50, name="city")
    private ItemValueType city;
    @Column(length=50, name="district")
    private ItemValueType district;
    @Column(length=200)
    private String address;

    protected LocationValueType(ItemValueType province, ItemValueType city, ItemValueType district, String address) {
        this.setProvince(province);
        this.setCity(city);
        this.setDistrict(district);
        this.setAddress(address);
    }

    protected LocationValueType() {
    }

    public static LocationValueType create(ItemValueType province, ItemValueType city, ItemValueType district, String address) {
        LocationValueType locationValueType = new LocationValueType(province, city, district, address);
        return locationValueType;
    }

    @Transient
    public String getShortLocation() {
        StringBuilder sb = new StringBuilder();
        if (this.getProvince() != null) {
            sb.append(this.getProvince().getName());
        }
        if (this.getCity() != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getCity().getName());
        }
        if (this.getDistrict() != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getDistrict().getName());
        }
        return sb.toString();
    }

    public ItemValueType getProvince() {
        return this.province;
    }

    public ItemValueType getCity() {
        return this.city;
    }

    public ItemValueType getDistrict() {
        return this.district;
    }

    public String getAddress() {
        return this.address;
    }

    protected void setProvince(ItemValueType province) {
        this.province = province;
    }

    protected void setCity(ItemValueType city) {
        this.city = city;
    }

    protected void setDistrict(ItemValueType district) {
        this.district = district;
    }

    protected void setAddress(String address) {
        this.address = address;
    }
}

