package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendSchedul;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤排班Mapper接口
 * 
 * @author lin
 * @date 2021-09-06
 */
public interface AttendSchedulMapper{

    /**
     * 查询考勤排班
     * 
     * @param id 考勤排班ID
     * @return 考勤排班
     */
    AttendSchedul findById(Long id);

    /**
     * 查询考勤排班列表
     * 
     * @param attendSchedul 考勤排班
     * @return 考勤排班集合
     */
    List<AttendSchedul> selectList(AttendSchedul attendSchedul);

    /**
     * 删除考勤排班
     * 
     * @param id 考勤排班ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤排班
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendSchedul
     * @return
     */
    int save(AttendSchedul attendSchedul);

    /****
     * 选择修改
     * @param attendSchedul
     * @return
     */
    int updateSelective(AttendSchedul attendSchedul);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendSchedul> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendSchedul> findByBatchId(@Param("list") List<AttendSchedul> list);

}
