package com.bcxin.platform.mapper.attend;

import com.bcxin.oaflow.domain.MakeUpCard;
import com.bcxin.oaflow.domain.OaBusinessBaseEntity;
import com.bcxin.platform.domain.attend.AttendClock;
import com.bcxin.platform.dto.app.AppAttendSchedulClockDto;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.dto.attend.AttendSchedulDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤打卡记录Mapper接口
 * 
 * @author lin
 * @date 2021-08-27
 */
public interface AttendClockMapper{

    /**
     * 查询考勤打卡记录
     * 
     * @param id 考勤打卡记录ID
     * @return 考勤打卡记录
     */
    AttendClock findById(Long id);

    /**
     * 查询考勤打卡记录列表
     * 
     * @param attendClock 考勤打卡记录
     * @return 考勤打卡记录集合
     */
    List<AttendClockDto> selectList(AttendClockDto attendClock);

    /**
     * 删除考勤打卡记录
     * 
     * @param id 考勤打卡记录ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤打卡记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendClock
     * @return
     */
    int save(AttendClock attendClock);

    /****
     * 选择修改
     * @param attendClock
     * @return
     */
    int updateSelective(AttendClock attendClock);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendClock> list);

    /**
     * 批量保存
     * @param list
     */
    void updateBatchStatus(@Param("list") List<AttendClock> list);

    /**
     * 生成缺勤记录 定时器使用
     */
    void createAbsence();

    /**
     * 更新打卡状态 定时器使用
     */
    void updateClockStatus();

    void updateClockStatusForPer(@Param("perId")Long perId,@Param("schedulDate")String schedulDate);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendClock> findByBatchId(@Param("list") List<AttendClock> list);

    List<AttendClock> findByIds(@Param("list") String[] list);

    List<AttendClockDto> selectListForReport(AttendClockDto searchDto);

    List<AppAttendSchedulClockDto> selectListForApp(AppAttendSearchDto searchDto);

    List<AttendClockDto> selectListForOA(OaBusinessBaseEntity oaBusiness);

    AttendClockDto findByOABusiness(MakeUpCard oaBusiness);

    void remove(AttendSchedulDto attendSchedulDto);
}
