package com.bcxin.platform.dto.wallet;

import com.bcxin.platform.domain.wallet.ComWalletAccount;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 人员钱包账户dto
 *
 * @author llc
 * @date 2019-06-21
 */
@Data
public class ComWalletAccountDTO extends ComWalletAccount {

    /**
     * 验证码
     */
    @ApiModelProperty(value = "验证码")
    private String activeCode;

    /**
     * 短信类型
     */
    @ApiModelProperty(value = "短信类型")
    private String smsType;

    /**
     * 账户状态
     */
    @ApiModelProperty(value = "账户状态")
    private String accountStatus;

    /**
     * 银行名称
     */
    @ApiModelProperty(value = "银行名称")
    private String bankName;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始日期")
    private String startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束日期")
    private String endDate;

    /**
     * 金额
     */
    @ApiModelProperty(value = "金额")
    private BigDecimal amount;


    /**
     * 充值前端回调页面
     */
    @ApiModelProperty(value = "充值前端回调页面")
    private String callfrontUrl;

    /**
     * 订单号
     */
    private String orderId;

    /**
     * 股东信息列表
     */
    @ApiModelProperty(value = "股东信息列表")
    private List<ComWalletShareholderDTO> shareholderList;

    /**
     * 受益人信息列表
     */
    @ApiModelProperty(value = "受益人信息列表")
    private List<ComWalletBeneficiaryDTO> beneficiaryList;

    /**
     * 保证支付财智卡号
     */
    @ApiModelProperty(value = "保证支付财智卡号")
    private String cardno;
}
