package com.bcxin.platform.dto.insurance;

import com.bcxin.platform.domain.insurance.ComIns;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Author: 陈堂君
 * @Date: 2017/12/28
 * @Description: 
 * @Modified By: 
 */
@Data
public class ComInsDTO extends ComIns {
    private String province; //省份 GX SX
    private String proCode; //产品编码
    private String cacheId;//保全人员缓存ID
    private String orderId;
    private Long perId;
    private String importBatchId;
    private String comInsGuaProjectList;
    private String keyword;
    private String reviseType;//保全类型，1:增员；2:减员
    private String perIds; //3849823904823,223210312,2321,312 人员ID集合
    private String insPerDetailIds; //3849823904823,223210312,2321,312 在保ID集合
    private String idCards; //350612313215,350612313215,350612313215 人员身份证集合
    private String idCard; //人员身份证
    private String tlkProjectId; //项目id
    private String projectName; //项目名称
    //业务类型 0普通团险，1临保
    private String businessType = "0";
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getStartTime() {
        return startTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getEndTime() {
        return endTime;
    }
}
