package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 换班记录对象 tb_attend_change_shift
 * 
 * @author lin
 * @date 2021-09-20
 */
@Data
public class AttendChangeShift extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 换班记录ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 是否删除 1是0否 */
    @Excel(name = "是否删除 1是0否")
    private String isDelete;

    /** 换班申请人ID */
    @Excel(name = "换班申请人ID")
    @NotNull(message="换班申请人ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    /** 换班申请人上班日期 */
    @Excel(name = "换班申请人上班日期")
    @NotBlank(message="换班申请人上班日期不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String schedulDate;

    /** 排班ids */
    @Excel(name = "排班ids")
    private String schedulDetailIds;

    /** 被换班人ID */
    @Excel(name = "被换班人ID")
    @NotNull(message="被换班人ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long changePerId;

    /** 换班日期 */
    @Excel(name = "换班日期")
    @NotBlank(message="换班日期不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String changeDate;

    /** 被换班人排班ids */
    @Excel(name = "被换班人排班ids")
    private String changeSchedulDetailIds;

}
