package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 考勤地点定位对象 tb_attend_address
 * 
 * @author lin
 * @date 2022-04-09
 */
@Data
public class AttendAddress extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 考勤地点ID */
    @NotNull(message="考勤地点ID不能为空", groups = {UpdateGroup.class})
    private Long id;

    /** 是否删除 1是0否 */
    @Excel(name = "是否删除 1是0否")
    private String isDelete;

    /** 定位经度 */
    @Excel(name = "定位经度")
    @NotBlank(message="定位经度不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String longitude;

    /** 定位纬度 */
    @Excel(name = "定位纬度")
    @NotBlank(message="定位纬度不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String latitude;

    /** 定位地址 */
    @Excel(name = "定位地址")
    @NotBlank(message="定位地址不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String address;

    /** 定位有效范围 */
    @Excel(name = "定位有效范围")
    @NotBlank(message="定位有效范围不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private Integer validRange;

    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @NotNull(message="考勤套ID不能为空", groups = {AddGroup.class})
    private Long attendId;

}
