package com.bcxin.platform.service.wallet;

import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.wallet.ComWalletChangeDetail;
import com.bcxin.platform.domain.wallet.ComWalletChangeEvent;
import com.bcxin.platform.dto.wallet.ComWalletAccountDTO;
import com.bcxin.platform.dto.wallet.ComWalletChangeDTO;
import com.bcxin.platform.mapper.wallet.ComWalletAccountMapper;
import com.bcxin.platform.mapper.wallet.ComWalletChangeMapper;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * <b> 企业钱包信息变更服务 </b>
 *
 * @author ZXF
 * @create 2019/09/17 0017 16:03
 * @注意事项 </b>
 */
@Service
@Transactional("transactionManager")
public class ComWalletChangeServiceImpl implements ComWalletChangeService {

    @Resource
    private ComWalletAccountMapper comWalletAccountMapper;

    @Resource
    private ComWalletChangeMapper comWalletChangeMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * <b> 保存钱包银行卡信息变更 </b>
     *
     * @author ZXF
     * @create 2019/09/17 0017 16:06
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result saveBankCardChangeEvent(ComWalletChangeDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (StringUtils.isEmpty(dto.getBankCardNo())) {
            throw new V5BusinessException(Result.ERROR, "新绑定卡卡号不能为空");
        }
        if (StringUtils.isEmpty(dto.getBankCode())) {
            throw new V5BusinessException(Result.ERROR, "新绑定卡银行代码不能为空");
        }
        if (StringUtils.isEmpty(dto.getBankName())) {
            throw new V5BusinessException(Result.ERROR, "新绑定卡银行不能为空");
        }
        if (StringUtils.isEmpty(dto.getBankCardUrl())) {
            throw new V5BusinessException(Result.ERROR, "旧绑定卡开户许可证不能为空");
        }
        if (StringUtils.isEmpty(dto.getChangeProveUrl())) {
            throw new V5BusinessException(Result.ERROR, "企业钱包信息修改证明不能为空");
        }
        if (comWalletChangeMapper.isUnApproveEvent(dto.getComId()) > 0) {
            throw new V5BusinessException(Result.ERROR, "已有审批中的修改银行卡记录，请等待审核");
        }
        //查询钱包信息
        ComWalletAccountDTO accountDto = comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        if (dto.getBankCode().equals(accountDto.getBankCode()) && dto.getBankCardNo().equals(accountDto.getBankCardNo())) {
            throw new V5BusinessException(Result.ERROR, "变更信息不能与历史信息一致");
        }
        /*创建变更事件*/
        Long eventId = idWorker.nextId();
        ComWalletChangeEvent event = new ComWalletChangeEvent();
        event.setComWalletChangeEventId(eventId);
        event.setComName(accountDto.getComName());
        event.setComId(dto.getComId());
        event.setChangeProveUrl(dto.getChangeProveUrl());
        event.setComWalletChangeType(DictConst.COMWALLETCHANGETYPE_CARD);
        event.setBankCardUrl(dto.getBankCardUrl());
        event.setWalletAccountNo(accountDto.getWalletAccountNo());
        event.setApproveStatus(DictConst.APPROVESTATUS_SPZ);
        event.setCreateTime(new Date());
        event.setCreateBy(dto.getCreateBy());
        /*创建变更字段记录*/
        String[] fields = {"bankCode", "bankCardNo"};
        ComWalletChangeDetail detail;
        List<ComWalletChangeDetail> list = Lists.newArrayList();
        for (String f : fields) {
            detail = new ComWalletChangeDetail();
            detail.setComWalletChangeDetailId(idWorker.nextId());
            detail.setComWalletChangeEventId(eventId);
            detail.setCreateBy(dto.getCreateBy());
            if ("bankCode".equals(f)) {
                if (dto.getBankCode().equals(accountDto.getBankCode())) {
                    continue;
                }
                detail.setChangeBeforeInfo(accountDto.getBankCode());
                detail.setChangeBeforeShowInfo(accountDto.getBankName());
                detail.setChangeAfterInfo(dto.getBankCode());
                detail.setChangeAfterShowInfo(dto.getBankName());
                detail.setChangeCode("bankCode");
                detail.setChangeCodeCn("银行编码");
            } else {
                if (dto.getBankCardNo().equals(accountDto.getBankCardNo())) {
                    continue;
                }
                detail.setChangeBeforeInfo(accountDto.getBankCardNo());
                detail.setChangeBeforeShowInfo(accountDto.getBankCardNo());
                detail.setChangeAfterInfo(dto.getBankCardNo());
                detail.setChangeAfterShowInfo(dto.getBankCardNo());
                detail.setChangeCode("bankCardNo");
                detail.setChangeCodeCn("银行卡号");
            }
            //企业钱包账户表
            detail.setChangeCodeTable("com_wallet_account");
            detail.setTableType(DictConst.TABLETYPE_XB);
            list.add(detail);
        }
        if (list.size() == 0) {
            throw new V5BusinessException(Result.ERROR, "企业钱包变更信息收集异常");
        }
        comWalletChangeMapper.insertComWalletChangeEvent(event);
        comWalletChangeMapper.batchSetComWalletChangeDetail(list);
        return Result.success(Result.SUCCESS_MSG);
    }
}