package com.bcxin.platform.service.meeting;

import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import com.bcxin.platform.dto.meeting.PerHuaweiMeetMatchDto;

/**
 * 人员华为云会议映射
 *
 * @author llc
 * @date 2019-12-03
 */
public interface PerHuaweiMeetMatchService {


    /**
     * 华为云鉴权
     *
     * @param perHuaweiMeetMatch
     * @return
     * @auth llc
     * @date 2019-12-10
     */
    Result getHuaweiAccessToken(PerHuaweiMeetMatch perHuaweiMeetMatch) throws PlatFormBusinessException;


    /**
     * 新增用户
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2019-12-10
     */
    Result addUser(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 设置监管机构负责人
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-12-03
     */
    Result setRegulatorMeetCharge(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 取消监管机构负责人
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-12-03
     */
    Result cancelRegulatorMeetCharge(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 批量删除用户
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2019-12-10
     */
    Result batchDeleteUser(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 离职自动批量删除用户
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2019-12-16
     */
    Result leaveJonBatchDeleteUser(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 查询会议列表
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2019-12-16
     */
    Result getHuaweiMeetList(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 发送华为云会议通知短信
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2019-12-17
     */
    Result sendHuaweiMeetSms(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 获取录播文件列表
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-02-03
     */
    Result getTranscribeFileList(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 批量删除录播文件
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-02-04
     */
    Result batchDeleteTranscribeFile(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;


    /**
     * 查询会议详情
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-10-13
     */
    Result getHuaweiMeetDetail(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;
}
