package com.bcxin.platform.mapper.wallet;

import com.bcxin.platform.domain.wallet.ComWalletAccountDetail;
import com.bcxin.platform.dto.wallet.ComWalletAccountDetailDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业钱包账户明细
 *
 * @author lp
 * @date 2019-12-10
 */
public interface ComWalletAccountDetailMapper {

    /**
     * 批量插入
     */
    int insertBatch(@Param("detailList") List<ComWalletAccountDetailDTO> detailList);

    List<ComWalletAccountDetail> selectByWalletNoAndDate(@Param("walletNo") String walletNo,
                                                         @Param("startDate") String startDate,
                                                         @Param("endDate") String endDate);

    List<ComWalletAccountDetail> selectByComIdAndDate(@Param("comId") Long comId,
                                                      @Param("startDate") String startDate,
                                                      @Param("endDate") String endDate,
                                                      @Param("isHideCheck") String isHideCheck);

    List<String> selectFlowNoByDate(@Param("startDate") String startDate,
                                    @Param("endDate") String endDate);

    String getVoucherUrlByFlowNo(@Param("flowNo") String flowNo,
                                 @Param("comId") Long comId);

    /**
     * <b> 查询电子回单地址 </b>
     * @author ZXF
     * @create 2023/05/25 0025 14:48
     * @version
     * @注意事项 </b>
     */
    String getVoucherUrlByTradeFlowNo(@Param("tradeFlowNo") String tradeFlowNo,
                                      @Param("comId") Long comId);
    /**
     * <b> 查询交易日期 yyyyMMdd </b>
     * @author ZXF
     * @create 2023/05/25 0025 14:49
     * @version
     * @注意事项 </b>
     */
    String getTradeDateByTradeFlowNo(@Param("tradeFlowNo") String tradeFlowNo,
                                      @Param("comId") Long comId);

    /**
     * <b> 查询入账方保证金账户号 </b>
     * @author ZXF
     * @create 2023/05/25 0025 14:49
     * @version
     * @注意事项 </b>
     */
    String getAccountInByTradeFlowNo(@Param("tradeFlowNo") String tradeFlowNo,
                                      @Param("comId") Long comId);

    int updateVoucherUrl(@Param("tradeFlowNo")String tradeFlowNo,@Param("voucherUrl")String voucherUrl);
    int updateVoucherUrlByComId(@Param("comId") Long comId,@Param("voucherUrl")String voucherUrl,@Param("tradeFlowNo")String tradeFlowNo);

}