package com.bcxin.platform.dto.company;

import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.domain.company.ComDepart;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class ComDepartDto extends ComDepart {
	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long perID;
	/**
	 * 人员IDs
	 */
	@ApiModelProperty(value = "人员ID集合")
	private String perIds;

	/**
	 * 组织ID
	 */
	@ApiModelProperty(value = "组织ID")
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long orgId;
	/**
	 * 原部门主管人员ID
	 */
	@ApiModelProperty(value = "原部门主管人员ID")
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long oldPerID;
	/**
	 * 原部门主管人员姓名
	 */
	private String oldPerName;

	/**
	 * 有没有下级
	 */
	private Boolean haveChild;
	/**
	 * 公司名字
	 */
	private String companyName;

	/**
	 * 公司（部门）id别名
	 */
	private String key;
	/**
	 * 公司（部门）名字别名title
	 */
	private String title;
	/**
	 * 公司的下级部门
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<ComDepartDto> children;

	/**
	 * 限制类型
	 */
	@ApiModelProperty(value = "限制类型：0为不限，1为部门，2为任务")
	private String limitType;

	private Integer personNumber;
	/**
	 * 关键字查询
	 */
	@ApiModelProperty(value = "关键字查询")
	private String keyword;
	/**
	 * 批量部门数据
	 */
	@ApiModelProperty(value = "批量部门数据")
	private String comDeparts;


	/**
	 * 树类型  1 代表组织  2 代表个人
	 */
	@ApiModelProperty(value = "树类型")
	private String treeType;

	/**
	 * 是否存在数据权限
	 */
	private String isExistsDataAuth;


	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerID() {
		return perID;
	}


	@JsonSerialize(using = ToStringSerializer.class)
	public Long getOldPerID() {
		return oldPerID;
	}



	@JsonSerialize(using = ToStringSerializer.class)
	public Long getOrgId() {
		return orgId;
	}



}
