package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * @author linqinglin
 * @date 2021/08/12 0012 13:20
 */
@Data
public class AttendSchedulPerDto extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long attendId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long deptId;

    private String name;
}
