package com.bcxin.platform.domain.grant;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业发放记录-个人
 * 
 * @author lp
 * @date 2020-03-31
 */
@Data
@TableName("com_grant_record_detail")
public class ComGrantRecordDetail extends BaseEntity<ComGrantRecordDetail> {

	/** 企业发放记录个人ID */
	@ApiModelProperty(value = "企业发放记录个人ID")
	private Long comGrantRecordDetailId;

	/** 企业发放记录ID */
	@ApiModelProperty(value = "企业发放记录ID")
	private Long comGrantRecordId;

	/** 企业发放明细ID */
	@ApiModelProperty(value = "企业发放明细ID")
	private Long comGrantDetailId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComGrantRecordDetailId() {
		return comGrantRecordDetailId;
	}

}