import axios from "axios";

const instance = axios.create({
  // axios中请求配置有baseURL选项，表示请求URL公共部分
  baseURL: process.env.VUE_APP_GWSD_API_ROOT,
  timeout: 60000,
});

instance.interceptors.request.use(
  async (config) => {
    config.headers.auth_code = localStorage.getItem("auth_code") ?? "37TBSAERG28";
    return config;
  },
  (error) => {
    return Promise.reject(error);
  }
);

instance.interceptors.response.use((response) => {
  const { status, data } = response;
  if (status === 200) {
    return data;
  }
});

export default instance;
