package com.bcxin.shared.rest.web.apis.controllers.rbacs;

import com.bcxin.api.interfaces.rbacs.RbacUserRpcProvider;
import com.bcxin.api.interfaces.rbacs.requests.AssignUserRequest;
import com.bcxin.rest.web.commons.ControllerAbstract;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/rbac/subjects/{subjectId}/users")
public class UserController extends ControllerAbstract {
    private final RbacUserRpcProvider userRpcProvider;

    public UserController(RbacUserRpcProvider userRpcProvider) {
        this.userRpcProvider = userRpcProvider;
    }

    @PostMapping("/assign-permissions")
    public ResponseEntity assign(@PathVariable String subjectId, @RequestBody AssignUserRequest request) {
        this.userRpcProvider.assign(subjectId, request);

        return this.ok();
    }
}
