package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.identities.requests.InvitedToJoinQueuesRequest;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.InvitedToJoinQueuesRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeCriteria;
import com.bcxin.api.interfaces.tenants.criterias.InvitedToJoinQueuesCriteria;
import com.bcxin.api.interfaces.tenants.responses.EmployeeGetResponse;
import com.bcxin.api.interfaces.tenants.responses.InvitedToJoinQueuesGetResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Validated
@RestController
@RequestMapping("/tenant/organizations/{organizationId}/invitedToJoinQueues")
public class InvitedToJoinQueuesController extends ControllerAbstract {

    private final EmployeeRpcProvider employeeRpcProvider;

    private final InvitedToJoinQueuesRpcProvider invitedToJoinQueuesRpcProvider;

    public InvitedToJoinQueuesController(EmployeeRpcProvider employeeRpcProvider, InvitedToJoinQueuesRpcProvider invitedToJoinQueuesRpcProvider) {
        this.employeeRpcProvider = employeeRpcProvider;
        this.invitedToJoinQueuesRpcProvider = invitedToJoinQueuesRpcProvider;
    }

    @ApiOperation(value = "获取待入职人员列表", response = InvitedToJoinQueuesGetResponse.class)
    @PostMapping("/search")
    public ResponseEntity search(@PathVariable String organizationId, @Valid @RequestBody InvitedToJoinQueuesCriteria criteria) {
        Pageable<InvitedToJoinQueuesGetResponse> data = this.invitedToJoinQueuesRpcProvider.find(organizationId, criteria);
        return this.ok(data);
    }

    @ApiOperation(value = "批量确认入职")
    @PostMapping("/action")
    public ResponseEntity doAction(@PathVariable String organizationId, @RequestBody InvitedToJoinQueuesRequest request){
        invitedToJoinQueuesRpcProvider.dispatch(organizationId,request);
        return this.ok();
    }
}
