package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.enums.InvitedType;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.InviteDepartRpcProvider;
import com.bcxin.api.interfaces.tenants.InvitedToJoinQueuesRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.employees.EmployeeRequest;
import com.bcxin.api.interfaces.tenants.responses.InviteDepartResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Validated
@RestController
@RequestMapping("/tenant/inviteDepart")
public class InviteDepartController extends ControllerAbstract {

    private final InviteDepartRpcProvider inviteDepartRpcProvider;

    private final EmployeeRpcProvider employeeRpcProvide;

    private final InvitedToJoinQueuesRpcProvider invitedToJoinQueuesRpcProvider;

    public InviteDepartController(InviteDepartRpcProvider inviteDepartRpcProvider,
                                  EmployeeRpcProvider employeeRpcProvide, InvitedToJoinQueuesRpcProvider invitedToJoinQueuesRpcProvider) {
        this.inviteDepartRpcProvider = inviteDepartRpcProvider;
        this.employeeRpcProvide = employeeRpcProvide;
        this.invitedToJoinQueuesRpcProvider = invitedToJoinQueuesRpcProvider;
    }


    @GetMapping("/getUnOvertime/{id}")
    public ResponseEntity<InviteDepartResponse> getUnOvertime(@PathVariable String id) {
        InviteDepartResponse responses = this.inviteDepartRpcProvider.getUnOvertime(id);
        if(responses == null){
            throw new NotFoundTenantException("该邀请不存在或者已截止！");
        }

        return this.ok(responses);
    }

    @ApiOperation(value = "新增企业职员信息-邀请入职")
    @PostMapping("add-employees/{inviteDepartId}")
    public ResponseEntity addInviteEmployees(@PathVariable String inviteDepartId,
                                             @Valid @RequestBody EmployeeRequest request) {

        this.invitedToJoinQueuesRpcProvider.create(InvitedType.InviteDepart,inviteDepartId,request);

        return this.ok();

    }

}
