package com.bcxin.security.domains.entities;

import cn.hutool.core.date.DateTime;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.sql.Timestamp;

@Getter
@Setter
@Table(name = "tlk_attendance_site_base_info")
@Entity
public class AttendSiteEntity extends EntityAbstract implements IAggregate {

    @Id
    private String id;

    /**
     * 应用id
     */
    @Column(name = "applicationid")
    private String applicationId;

    /**
     * 公司id
     */
    @Column(name = "item_domain_id")
    private String domainId;

    /**
     * 负责人id
     */
    @Column(name = "item_principal")
    private String principalId;

    /**
     * 驻勤点名称
     */
    @Column(name = "item_attendancesitename")
    private String attendSiteName;

    /**
     * 状态
     */
    @Column(name = "item_attendancesitestate")
    private String state;

    /**
     * 驻勤开始时间
     */
    @Column(name = "item_attendancestartdate")
    private Timestamp startDate;

    /**
     * 驻勤结束时间
     */
    @Column(name = "item_attendanceenddate")
    private Timestamp endDate;
}
