/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.security.domains.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="tlk_attendance_site_person_info")
@Entity
public class AttendSitePersonEntity
extends EntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="ITEM_SECURITYNAME")
    private String securityName;
    @Column(name="ITEM_SECURITYID")
    private String securityId;
    @Column(name="ITEM_DOCUMENTTYPE")
    @Enumerated(value=EnumType.ORDINAL)
    private CredentialType documentType;
    @Column(name="ITEM_DOCUMENTID")
    private String documentId;
    @Column(name="ITEM_PHONE")
    private String phone;
    @Column(name="ITEM_DEPTNAME")
    private String deptName;
    @Column(name="ITEM_JOBTYPE")
    @Enumerated(value=EnumType.ORDINAL)
    private OccupationType jobType;
    @Column(name="ITEM_ISCERTIFIED")
    private String isCertified;
    @Column(name="ITEM_INSURANCESTATUS")
    private String insuranceStatus;
    @Column(name="ITEM_CREATEDUSER")
    private String createdUser;
    @Column(name="ITEM_ATTENDANCESITEID")
    private String attendanceSiteId;
    @Column(name="DOMAINID")
    private String domainId;
    @Column(name="ITEM_DOMAIN_ID")
    private String iDomainId;
    @Column(name="AUTHOR")
    private String author;
    @Column(name="AUTHORDEPTID")
    private String authorDeptId;
    @Column(name="AUTHOR_DEPT_INDEX")
    private String authorDeptIndex;
    @Column(name="LASTMODIFIER")
    private String lastModifier;
    @Column(name="CREATED")
    private Timestamp created;
    @Column(name="LASTMODIFIED")
    private Timestamp lastModified;
    @Column(name="APPLICATIONID")
    private String applicationId;
    @Column(name="FORMID")
    private String formId;
    @Column(name="FORMNAME")
    private String formName;
    @Column(name="ISTMP")
    private boolean isTmp = false;
    @Column(name="STATEINT")
    private String stateint = "0";

    public AttendSitePersonEntity() {
    }

    public AttendSitePersonEntity(String securityName, String securityId, CredentialType documentType, String documentId, String phone, String deptName, OccupationType jobType, String isCertified, String insuranceStatus, String createdUser, String attendanceSiteId, String domainId, String author, String authorDeptId, String authorDeptIndex, String lastModifier, String applicationId, String formId, String formName) {
        this.securityName = securityName;
        this.securityId = securityId;
        this.documentType = documentType;
        this.documentId = documentId;
        this.phone = phone;
        this.deptName = deptName;
        this.jobType = jobType;
        this.isCertified = isCertified;
        this.insuranceStatus = insuranceStatus;
        this.createdUser = createdUser;
        this.attendanceSiteId = attendanceSiteId;
        this.domainId = domainId;
        this.iDomainId = domainId;
        this.author = author;
        this.authorDeptId = authorDeptId;
        this.authorDeptIndex = authorDeptIndex;
        this.lastModifier = lastModifier;
        this.applicationId = applicationId;
        this.formId = formId;
        this.formName = formName;
    }

    public static AttendSitePersonEntity create(String securityName, String securityId, CredentialType documentType, String documentId, String phone, String deptName, OccupationType jobType, String isCertified, String insuranceStatus, String createdUser, String attendanceSiteId, String domainId, String author, String authorDeptId, String authorDeptIndex, String lastModifier, String applicationId, String formId, String formName) {
        AttendSitePersonEntity attendSitePerson = new AttendSitePersonEntity(securityName, securityId, documentType, documentId, phone, deptName, jobType, isCertified, insuranceStatus, createdUser, attendanceSiteId, domainId, author, authorDeptId, authorDeptIndex, lastModifier, applicationId, formId, formName);
        attendSitePerson.setId(UUIDUtil.getShortUuid() + "--" + formId);
        attendSitePerson.setCreated(Timestamp.from(Instant.now()));
        attendSitePerson.setLastModified(Timestamp.from(Instant.now()));
        return attendSitePerson;
    }

    public String getId() {
        return this.id;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public String getSecurityId() {
        return this.securityId;
    }

    public CredentialType getDocumentType() {
        return this.documentType;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public OccupationType getJobType() {
        return this.jobType;
    }

    public String getIsCertified() {
        return this.isCertified;
    }

    public String getInsuranceStatus() {
        return this.insuranceStatus;
    }

    public String getCreatedUser() {
        return this.createdUser;
    }

    public String getAttendanceSiteId() {
        return this.attendanceSiteId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getIDomainId() {
        return this.iDomainId;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getAuthorDeptId() {
        return this.authorDeptId;
    }

    public String getAuthorDeptIndex() {
        return this.authorDeptIndex;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public Timestamp getLastModified() {
        return this.lastModified;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getFormName() {
        return this.formName;
    }

    public boolean isTmp() {
        return this.isTmp;
    }

    public String getStateint() {
        return this.stateint;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public void setDocumentType(CredentialType documentType) {
        this.documentType = documentType;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setJobType(OccupationType jobType) {
        this.jobType = jobType;
    }

    public void setIsCertified(String isCertified) {
        this.isCertified = isCertified;
    }

    public void setInsuranceStatus(String insuranceStatus) {
        this.insuranceStatus = insuranceStatus;
    }

    public void setCreatedUser(String createdUser) {
        this.createdUser = createdUser;
    }

    public void setAttendanceSiteId(String attendanceSiteId) {
        this.attendanceSiteId = attendanceSiteId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public void setIDomainId(String iDomainId) {
        this.iDomainId = iDomainId;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setAuthorDeptId(String authorDeptId) {
        this.authorDeptId = authorDeptId;
    }

    public void setAuthorDeptIndex(String authorDeptIndex) {
        this.authorDeptIndex = authorDeptIndex;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public void setCreated(Timestamp created) {
        this.created = created;
    }

    public void setLastModified(Timestamp lastModified) {
        this.lastModified = lastModified;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setTmp(boolean isTmp) {
        this.isTmp = isTmp;
    }

    public void setStateint(String stateint) {
        this.stateint = stateint;
    }
}

