package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.ResponseAbstract;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyRegistrationRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Getter
public class OrganizationApproveGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String unifySocialCreditCode;
    private final String unifySocialCreditCodeFile;
    private final String logoPath;
    private final LocationResponse placeOfRegister;
    private final LocationResponse placeOfBusiness;
    /**
     * 机构类型
     */
    private final String institutionalCode;
    /**
     * 行业类型
     */
    private final String industryCode;
    /**
     * 管理员
     */
    private final ContactResponse administrator;

    /**
     * 总经理
     */
    private final ContactResponse generalManager;

    /**
     * 副总经理
     */
    private final ContactResponse deputyGeneralManager;


    public OrganizationApproveGetResponse(String id,
                                          String name,
                                          String unifySocialCreditCode,
                                          String unifySocialCreditCodeFile,
                                          String logoPath,
                                          String institutionalCode,
                                          String industryCode,
                                          LocationResponse placeOfRegister,
                                          LocationResponse placeOfBusiness,
                                          ContactResponse administrator,
                                          ContactResponse generalManager,
                                          ContactResponse deputyGeneralManager) {
        this.id = id;
        this.name = name;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.logoPath = logoPath;
        this.institutionalCode = institutionalCode;
        this.industryCode = industryCode;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.administrator = administrator;
        this.generalManager = generalManager;
        this.deputyGeneralManager = deputyGeneralManager;
    }

    @Getter
    public static class LocationResponse extends ResponseAbstract {
        private final ItemValueResponse province;
        private final ItemValueResponse city;
        private final ItemValueResponse district;
        private final String address;

        public LocationResponse(ItemValueResponse province, ItemValueResponse city,
                                ItemValueResponse district, String address) {
            this.province = province;
            this.city = city;
            this.district = district;
            this.address = address;
        }
    }

    @Getter
    public static class ItemValueResponse extends ResponseAbstract {
        private final String code;
        private final String name;

        public ItemValueResponse(String code, String name) {
            this.code = code;
            this.name = name;
        }
    }

    @Data
    public static class ContactResponse implements Serializable {
        /**
         * 姓名
         */
        private String name;
        /**
         * 手机
         */
        private String telephone;
        /**
         * 证件类型
         */
        private CredentialType credentialType;
        /**
         * 证件号
         */
        private String credentialNumber;

        public ContactResponse(String name, String telephone, CredentialType credentialType, String credentialNumber){
            this.name = name;
            this.telephone = telephone;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
        }

        public static ContactResponse create(String name, String telephone, CredentialType credentialType, String credentialNumber) {
            return new ContactResponse(name,telephone,credentialType,credentialNumber);
        }
    }

}
