package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.OrganizationLevel;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@Getter
public class MyOrganizationProfileGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String industryCode;
    private final String institutionalCode;
    private final Collection<OrganizationLevel> organizationLevels;


    /**
     * 职员的基本信息
     */
    private final String employeeId;
    private final OccupationType occupationType;
    private final EmploymentStatus status;
    private final Date hiredTime;
    private final String tenantUserId;
    private final String accessToken;
    private final String businessToken;
    private final boolean isMaster;
    private final String areaCode;
    private final boolean isDomainAdmin;
    private final boolean isDepartAdmin;

    @ApiModelProperty("是否职员(true=职员;false=赛演人员的非员工);非员工不允许查看团队信息")
    private final boolean isEmployee;

    private List<String> permissions = new ArrayList<>();

    public MyOrganizationProfileGetResponse(
            String id, String name,
            String industryCode,
            String institutionalCode,
            String employeeId,
            String tenantUserId,
            OccupationType occupationType,
            EmploymentStatus status,
            Date hiredTime,
            MasterSlaveType masterSlaveType,
            String accessToken,String businessToken,
            boolean isDomainAdmin,
            boolean isDepartAdmin,
            String areaCode,
            boolean hiredDatedLimited,
            boolean leaveDatedLimited,
            boolean isEmployee,
            Collection<OrganizationLevel> organizationLevels) {
        this.id = id;
        this.name = name;
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.employeeId = employeeId;
        this.occupationType = occupationType;
        this.status = status;
        if(hiredTime==null) {
            this.hiredTime = hiredTime;
        }else {
            this.hiredTime = new Date();
        }

        this.tenantUserId = tenantUserId;
        /**
         * 是否为系统管理员
         */
        this.isMaster = masterSlaveType == MasterSlaveType.Master;

        this.accessToken = accessToken;
        this.businessToken=businessToken;
        this.isDomainAdmin = isDomainAdmin;
        this.isDepartAdmin = isDepartAdmin;
        this.areaCode = areaCode;
        this.organizationLevels = organizationLevels;
        this.isEmployee = isEmployee;

        if(isDomainAdmin || isDepartAdmin){
            permissions.add("ResetPwd");
            permissions.add("RoleManage");
        }
        if(hiredDatedLimited){
            permissions.add("hiredDatedLimited");
        }
        if(leaveDatedLimited){
            permissions.add("leaveDatedLimited");
        }
    }

    public static MyOrganizationProfileGetResponse create(
            String id, String name, String industryCode,
            String institutionalCode,
            String employeeId,
            String tenantUserId,
            OccupationType occupationType,
            EmploymentStatus status,
            Date hiredTime,
            MasterSlaveType masterSlaveType,
            String accessToken,
            String businessToken,
            boolean isDomainAdmin,
            boolean isDepartAdmin,
            String areaCode,
            boolean hiredDatedLimited,
            boolean leaveDatedLimited,
            boolean isEmployee,
            Collection<OrganizationLevel> organizationLevels) {
        return new MyOrganizationProfileGetResponse(
                id, name, industryCode, institutionalCode,
                employeeId, tenantUserId, occupationType,
                status, hiredTime, masterSlaveType, accessToken, businessToken, isDomainAdmin, isDepartAdmin,
                areaCode,
                hiredDatedLimited, leaveDatedLimited, isEmployee, organizationLevels);
    }
}
