package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.tenants.requests.ImportDepartmentRequest;
import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class ImportDepartmentResponse implements Serializable {
    private final Collection<ImportDepartmentResponseItem> items;

    public ImportDepartmentResponse(Collection<ImportDepartmentResponseItem> items) {
        this.items = items;
    }

    public static ImportDepartmentResponse create(Collection<ImportDepartmentResponseItem> items) {
        return new ImportDepartmentResponse(items);
    }

    @Getter
    public static class ImportDepartmentResponseItem implements Serializable {
        private final ImportDepartmentRequest request;
        private final String result;
        private final boolean isSuccess;
        public String getRequestName() {
            return request.getName();
        }

        public String getRequestParentTreeName() {
            return request.getParentTreeName();
        }

        public String getRequestDisplayOrder() {
            return request.getDisplayOrder();
        }

        public String getRequestPermissionType() {
            return request.getPermissionType();
        }


        public ImportDepartmentResponseItem(ImportDepartmentRequest request, String result, boolean isSuccess) {
            this.request = request;
            this.result = result;
            this.isSuccess = isSuccess;
        }

        public static ImportDepartmentResponseItem create(ImportDepartmentRequest request, String result, boolean isSuccess) {
            return new ImportDepartmentResponseItem(request, result, isSuccess);
        }
    }
}
