package com.bcxin.api.interfaces.tenants.responses;
import com.bcxin.api.interfaces.tenants.requests.employees.BatchImportEmployeeRequest;
import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class BatchImportEmployeeResponse implements Serializable {
    private final Collection<ImportEmployeeResponseItem> items;

    public BatchImportEmployeeResponse(Collection<ImportEmployeeResponseItem> items) {
        this.items = items;
    }

    public static BatchImportEmployeeResponse create(Collection<ImportEmployeeResponseItem> items) {
        return new BatchImportEmployeeResponse(items);
    }

    @Getter
    public static class ImportEmployeeResponseItem implements Serializable {
        private final BatchImportEmployeeRequest request;
        private final String result;
        private final boolean isSuccess;

        public ImportEmployeeResponseItem(BatchImportEmployeeRequest request,
                                          String result, boolean isSuccess) {
            this.request = request;
            this.result = result;
            this.isSuccess = isSuccess;
        }

        public static ImportEmployeeResponseItem create(BatchImportEmployeeRequest request,
                                                        String result, boolean isSuccess) {
            return new ImportEmployeeResponseItem(request, result, isSuccess);
        }
    }
}
