package com.bcxin.api.interfaces.tenants.requests.tenantUsers;
import lombok.Data;

import java.io.Serializable;


@Data
public class IMContactCriteria implements Serializable {
    private  int pageIndex;
    private  int pageSize;
    private String keyword;
    private String organizationId;
    private String departId;
    private String userId;


    public IMContactCriteria(int pageIndex, int pageSize, String organizationId, String departId, String userId) {
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;
        this.organizationId = organizationId;
        this.departId = departId;
        this.userId = userId;
    }
    public IMContactCriteria(int pageIndex, int pageSize,String keyword, String organizationId, String departId, String userId) {
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;
        this.keyword = keyword;
        this.organizationId = organizationId;
        this.departId = departId;
        this.userId = userId;
    }

    public static IMContactCriteria create(int pageIndex, int pageSize,String organizationId, String departId, String userId){
        return new IMContactCriteria(pageIndex,pageSize,organizationId,departId,userId);
    }


    public int getSkip() {
        int index = pageIndex - 1;
        if (index < 0) {
            index = 0;
        }

        return this.getPageSize() * index;
    }
}
