package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.enums.PersonResourceType;
import com.bcxin.api.interfaces.identities.requests.GetCredentialRequest;
import com.bcxin.api.interfaces.tenants.criterias.TenantUserRegionCriteria;
import com.bcxin.api.interfaces.tenants.requests.TocWechatCgiConfirmCheckStatusRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.*;
import com.bcxin.api.interfaces.tenants.responses.*;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

@Component("userRpcProvider")
public interface UserRpcProvider {
    UserProfileGetResponse get(String id);

    Collection<MyOrganizationProfileGetResponse> getById(String id);

    Collection<MyTeamGetResponse> getMyTeamsByUserId(String id);

    UserOrganBasicGetResponse getByIdAndOrganId(String organId, String tenantUserId, PersonResourceType resourceType);

    void update(String id, UpdateTenantUserRequest request);

    void update(String id, SyncTenantUserLocationRequest request);

    void updateDeviceId(String id, String cid);

    void updateBasic(String id, UpdateBasicTenantUserRequest request);

    void updateCredential(String id, UpdateCredentialRequest request);

    void changeCredential(String id, UpdateCredentialImageRequest request);

    void updatePhoto(String id, UpdateTenantPhotoRequest request);

    /**
     * description：修改昵称/头像
     * author：linchunpeng
     * date：2025/5/20
     */
    void updateNickHeadPhoto(String id, UpdateNickHeadPhotoRequest request);

    void syncWechatLabel(String id, SyncWechatLabelRequest request);

    UserDetailGetResponse getDetail(String id);

    void reRealNameAuthenticate(String id,boolean checkAuthenticate);

    void notifyMessage(String id, String eventId);

    Pageable<CredentialResponse> getCredentials(String id, String organizationId, GetCredentialRequest request);

    List<XlcpReportResponse> xlcps(String id, String organizationId);

    boolean xlcpValidOrNot(String organizationId,String id,String currentUserId);

    List<CurrentCredentialResponse> getCredentials(QueryCredentialRequest queryRequest);

    List<QualificationCredentialResponse> getQualificationCredentials(QueryCredentialRequest queryRequest);

    String getCidByPhone(String phone);

    List<UserRegionGetResponse> getUsersByRegion(TenantUserRegionCriteria criteria);

    void updateUserRealName(List<UpdateTenantUserRealNameRequest> requests);

    /**
     * @param id
     * @param credentialType
     * @param credentialNumber
     * @return UserCredentialResponse
     * @Description 根据tenant_user_id、证件类型以及证件号码获取证件信息
     */
    UserCredentialResponse getUserCredential(String id, Integer credentialType, String credentialNumber);

    void updateCredentialByBkt(String id, UpdateCredentialRequest request);

    boolean getCheckStatusByBkt(String id);

    void createAuthAppeal(String id, CreateAuthAppealRequest request);

    Collection<UserAppealsResponse> getUserAppeals(GetAuthAppealsRequest request);

    /**
     * description：平台操作-变更用户姓名/手机信息
     * author：linchunpeng
     * date：2024/11/12
     */
    void updateUserBasicByPlatform(PlatformUpdateUserBasicRequest request);

    /**
     * description：平台操作重新实名认证
     * author：linchunpeng
     * date：2024/11/12
     */
    void resetAuthenticateStatusByPlatform(PlatformResetAuthenticateStatusRequest request);

    /**
     * description：重置密码
     * author：linchunpeng
     * date：2024/11/12
     */
    void resetPasswordByPlatform(PlatformResetPasswordRequest request);

    TocWechatCgiConfirmCheckStatusResponse confirmCheckStatusForToc(TocWechatCgiConfirmCheckStatusRequest request);

    /**
     * description：保存用户拓展信息
     * author：linchunpeng
     * date：2025/5/22
     */
    void saveTenantUserExtension(String id, TenantUserExtensionListRequest request);
}
