package com.bcxin.api.interfaces.rbacs.custom.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


@ApiModel("职员已授权应用返回对象")
@Data
public class RbacPermitAppAuthResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "应用ID")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long appId;

    @ApiModelProperty(value = "应用代码")
    private String appCode;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "应用logo")
    private String appLogo;

    @ApiModelProperty(value = "应用分类")
    private String category;

    @ApiModelProperty(value = "操作项列表")
    private List<RbacPermitOptionAuthResponse> optionList;

}
