/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.utils.CdnUtils;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.Infrastructures.utils.StringUtils;
import java.io.Serializable;
import java.util.Date;

public class UserCredentialResponse
implements Serializable {
    private String name;
    private String credentialNumber;
    private String credentialType;
    private String fzjgmc;
    private String fzrq;
    private String telephone;
    private String checkedStatus;
    private String authenticatedStatus;
    private String identityNumber;
    private String headPhoto;
    private String reversePhoto;
    private String frontPhoto;
    private String address;

    public String getSex() {
        if (StringUtils.isEmpty((String)this.getIdentityNumber())) {
            return "\u672a\u77e5";
        }
        if (this.getIdentityNumber().length() < 15) {
            return "\u672a\u77e5";
        }
        String cardNo = this.getIdentityNumber();
        String sexStr = "";
        if (cardNo.length() == 15) {
            sexStr = cardNo.substring(14, 15);
        } else if (cardNo.length() == 18) {
            sexStr = cardNo.substring(16, 17);
        }
        int sexNo = Integer.parseInt(sexStr);
        String sex = sexNo % 2 == 0 ? "\u5973" : "\u7537";
        return sex;
    }

    public UserCredentialResponse() {
    }

    public UserCredentialResponse(String name, String credentialNumber, String credentialType, String fzjgmc, String fzrq, String telephone, String checkedStatus, String authenticatedStatus, String identityNumber, String headPhoto, String reversePhoto, String frontPhoto, String address) {
        this.name = name;
        this.credentialNumber = credentialNumber;
        this.credentialType = credentialType;
        this.fzjgmc = fzjgmc;
        this.fzrq = fzrq;
        this.telephone = telephone;
        this.checkedStatus = checkedStatus;
        this.authenticatedStatus = authenticatedStatus;
        this.identityNumber = identityNumber;
        this.headPhoto = CdnUtils.convert((String)headPhoto);
        this.reversePhoto = CdnUtils.convert((String)reversePhoto);
        this.frontPhoto = CdnUtils.convert((String)frontPhoto);
        this.address = address;
    }

    public static UserCredentialResponse create(String name, String credentialNumber, Integer credentialType, String fzjgmc, Date fzrq, String telephone, Integer checkedStatus, Integer authenticatedStatus, String idnum, String headPhoto, String reversePhoto, String frontPhoto, String address) {
        return new UserCredentialResponse(name, credentialNumber, UserCredentialResponse.getCredentialType(credentialType), fzjgmc, fzrq != null ? DateUtil.format2ShortDate((Date)fzrq) : null, telephone, UserCredentialResponse.getCheckedStatus(checkedStatus), UserCredentialResponse.getAuthenticatedStatus(authenticatedStatus), idnum, headPhoto, reversePhoto, frontPhoto, address);
    }

    private static String getCheckedStatus(Integer checkedStatus) {
        String name = null;
        if (checkedStatus != null) {
            for (UserCheckedStatus value : UserCheckedStatus.values()) {
                if (value.ordinal() != checkedStatus.intValue()) continue;
                name = value.getTypeName();
                break;
            }
        }
        return name;
    }

    private static String getCredentialType(Integer credentialType) {
        String name = null;
        if (credentialType != null) {
            for (CredentialType value : CredentialType.values()) {
                if (value.ordinal() != credentialType.intValue()) continue;
                name = value.getTypeName();
                break;
            }
        }
        return name;
    }

    private static String getAuthenticatedStatus(Integer authenticatedStatus) {
        String name = null;
        if (authenticatedStatus != null) {
            for (RealNameAuthenticatedStatus value : RealNameAuthenticatedStatus.values()) {
                if (value.ordinal() != authenticatedStatus.intValue()) continue;
                name = value.getTypeName();
                break;
            }
        }
        return name;
    }

    public String getName() {
        return this.name;
    }

    public String getCredentialNumber() {
        return this.credentialNumber;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getFzjgmc() {
        return this.fzjgmc;
    }

    public String getFzrq() {
        return this.fzrq;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getCheckedStatus() {
        return this.checkedStatus;
    }

    public String getAuthenticatedStatus() {
        return this.authenticatedStatus;
    }

    public String getIdentityNumber() {
        return this.identityNumber;
    }

    public String getHeadPhoto() {
        return this.headPhoto;
    }

    public String getReversePhoto() {
        return this.reversePhoto;
    }

    public String getFrontPhoto() {
        return this.frontPhoto;
    }

    public String getAddress() {
        return this.address;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCredentialNumber(String credentialNumber) {
        this.credentialNumber = credentialNumber;
    }

    public void setCredentialType(String credentialType) {
        this.credentialType = credentialType;
    }

    public void setFzjgmc(String fzjgmc) {
        this.fzjgmc = fzjgmc;
    }

    public void setFzrq(String fzrq) {
        this.fzrq = fzrq;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public void setCheckedStatus(String checkedStatus) {
        this.checkedStatus = checkedStatus;
    }

    public void setAuthenticatedStatus(String authenticatedStatus) {
        this.authenticatedStatus = authenticatedStatus;
    }

    public void setIdentityNumber(String identityNumber) {
        this.identityNumber = identityNumber;
    }

    public void setHeadPhoto(String headPhoto) {
        this.headPhoto = headPhoto;
    }

    public void setReversePhoto(String reversePhoto) {
        this.reversePhoto = reversePhoto;
    }

    public void setFrontPhoto(String frontPhoto) {
        this.frontPhoto = frontPhoto;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCredentialResponse)) {
            return false;
        }
        UserCredentialResponse other = (UserCredentialResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$credentialNumber = this.getCredentialNumber();
        String other$credentialNumber = other.getCredentialNumber();
        if (this$credentialNumber == null ? other$credentialNumber != null : !this$credentialNumber.equals(other$credentialNumber)) {
            return false;
        }
        String this$credentialType = this.getCredentialType();
        String other$credentialType = other.getCredentialType();
        if (this$credentialType == null ? other$credentialType != null : !this$credentialType.equals(other$credentialType)) {
            return false;
        }
        String this$fzjgmc = this.getFzjgmc();
        String other$fzjgmc = other.getFzjgmc();
        if (this$fzjgmc == null ? other$fzjgmc != null : !this$fzjgmc.equals(other$fzjgmc)) {
            return false;
        }
        String this$fzrq = this.getFzrq();
        String other$fzrq = other.getFzrq();
        if (this$fzrq == null ? other$fzrq != null : !this$fzrq.equals(other$fzrq)) {
            return false;
        }
        String this$telephone = this.getTelephone();
        String other$telephone = other.getTelephone();
        if (this$telephone == null ? other$telephone != null : !this$telephone.equals(other$telephone)) {
            return false;
        }
        String this$checkedStatus = this.getCheckedStatus();
        String other$checkedStatus = other.getCheckedStatus();
        if (this$checkedStatus == null ? other$checkedStatus != null : !this$checkedStatus.equals(other$checkedStatus)) {
            return false;
        }
        String this$authenticatedStatus = this.getAuthenticatedStatus();
        String other$authenticatedStatus = other.getAuthenticatedStatus();
        if (this$authenticatedStatus == null ? other$authenticatedStatus != null : !this$authenticatedStatus.equals(other$authenticatedStatus)) {
            return false;
        }
        String this$identityNumber = this.getIdentityNumber();
        String other$identityNumber = other.getIdentityNumber();
        if (this$identityNumber == null ? other$identityNumber != null : !this$identityNumber.equals(other$identityNumber)) {
            return false;
        }
        String this$headPhoto = this.getHeadPhoto();
        String other$headPhoto = other.getHeadPhoto();
        if (this$headPhoto == null ? other$headPhoto != null : !this$headPhoto.equals(other$headPhoto)) {
            return false;
        }
        String this$reversePhoto = this.getReversePhoto();
        String other$reversePhoto = other.getReversePhoto();
        if (this$reversePhoto == null ? other$reversePhoto != null : !this$reversePhoto.equals(other$reversePhoto)) {
            return false;
        }
        String this$frontPhoto = this.getFrontPhoto();
        String other$frontPhoto = other.getFrontPhoto();
        if (this$frontPhoto == null ? other$frontPhoto != null : !this$frontPhoto.equals(other$frontPhoto)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserCredentialResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $credentialNumber = this.getCredentialNumber();
        result = result * 59 + ($credentialNumber == null ? 43 : $credentialNumber.hashCode());
        String $credentialType = this.getCredentialType();
        result = result * 59 + ($credentialType == null ? 43 : $credentialType.hashCode());
        String $fzjgmc = this.getFzjgmc();
        result = result * 59 + ($fzjgmc == null ? 43 : $fzjgmc.hashCode());
        String $fzrq = this.getFzrq();
        result = result * 59 + ($fzrq == null ? 43 : $fzrq.hashCode());
        String $telephone = this.getTelephone();
        result = result * 59 + ($telephone == null ? 43 : $telephone.hashCode());
        String $checkedStatus = this.getCheckedStatus();
        result = result * 59 + ($checkedStatus == null ? 43 : $checkedStatus.hashCode());
        String $authenticatedStatus = this.getAuthenticatedStatus();
        result = result * 59 + ($authenticatedStatus == null ? 43 : $authenticatedStatus.hashCode());
        String $identityNumber = this.getIdentityNumber();
        result = result * 59 + ($identityNumber == null ? 43 : $identityNumber.hashCode());
        String $headPhoto = this.getHeadPhoto();
        result = result * 59 + ($headPhoto == null ? 43 : $headPhoto.hashCode());
        String $reversePhoto = this.getReversePhoto();
        result = result * 59 + ($reversePhoto == null ? 43 : $reversePhoto.hashCode());
        String $frontPhoto = this.getFrontPhoto();
        result = result * 59 + ($frontPhoto == null ? 43 : $frontPhoto.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    public String toString() {
        return "UserCredentialResponse(name=" + this.getName() + ", credentialNumber=" + this.getCredentialNumber() + ", credentialType=" + this.getCredentialType() + ", fzjgmc=" + this.getFzjgmc() + ", fzrq=" + this.getFzrq() + ", telephone=" + this.getTelephone() + ", checkedStatus=" + this.getCheckedStatus() + ", authenticatedStatus=" + this.getAuthenticatedStatus() + ", identityNumber=" + this.getIdentityNumber() + ", headPhoto=" + this.getHeadPhoto() + ", reversePhoto=" + this.getReversePhoto() + ", frontPhoto=" + this.getFrontPhoto() + ", address=" + this.getAddress() + ")";
    }
}

