package com.bcxin.shared.rest.web.apis.controllers.commons;

import com.bcxin.api.interfaces.commons.SuperviseDepartmentRpcProvider;
import com.bcxin.rest.web.commons.ControllerAbstract;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * description: 监管机构
 * author: linchunpeng
 * date:  2023-05-10 9:41
 */
@RestController
@RequestMapping("/common/supervise")
public class SuperviseDepartmentController extends ControllerAbstract {

    private final SuperviseDepartmentRpcProvider superviseDepartmentRpcProvider;

    public SuperviseDepartmentController(SuperviseDepartmentRpcProvider superviseDepartmentRpcProvider) {
        this.superviseDepartmentRpcProvider = superviseDepartmentRpcProvider;
    }


    /**
     * description: 根据区域id获取监管机构树形结构
     * author: linchunpeng
     * date:  2023-05-10 9:37
     */
    @GetMapping("/find/tree/{regionId}/{industryCode}")
    public ResponseEntity getOrgTypeList(@PathVariable("regionId") String regionId,
                                         @PathVariable("industryCode") String industryCode) {
        return this.ok(this.superviseDepartmentRpcProvider.findByRegionId(regionId, industryCode));
    }


    /**
     * description: 删除注册页面数据字典缓存
     * author: linchunpeng
     * date:  2023-05-08 14:34
     */
    @GetMapping("/clear/redis/{regionId}")
    public ResponseEntity clearRedis(@PathVariable("regionId") String regionId) {
        this.superviseDepartmentRpcProvider.clearRedis(regionId);
        return this.ok();
    }
}
