package com.bcxin.shared.rest.web.apis.controllers.commons;

import com.bcxin.api.interfaces.commons.RegionRpcProvider;
import com.bcxin.rest.web.commons.ControllerAbstract;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/common/region")
public class RegionController extends ControllerAbstract {

    private final RegionRpcProvider regionRpcProvider;

    public RegionController(RegionRpcProvider regionRpcProvider) {
        this.regionRpcProvider = regionRpcProvider;
    }


    @RequestMapping("/list")
    public ResponseEntity list(String parentId) {
        return this.ok(this.regionRpcProvider.findByParentId(parentId));
    }

    @GetMapping("/all")
    public ResponseEntity all() {
        return this.ok(this.regionRpcProvider.findAll());
    }
}
