package com.bcxin.shared.rest.web.apis;

import com.bcxin.Infrastructures.TenantConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
public class SharedWebApp implements WebMvcConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(SharedWebApp.class);

    private final TenantConfigProperty configProperty;

    public SharedWebApp(TenantConfigProperty configProperty) {
        this.configProperty = configProperty;
    }

    public static void main(String[] args) {
        try {
            SpringApplication.run(SharedWebApp.class, args);
        } catch (Exception ex) {
            logger.error("failed to startup", ex);
        }
    }
}