/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.services.impls;

import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.AppConfigProperty;
import com.bcxin.backend.core.components.StorageProvider;
import com.bcxin.backend.core.exceptions.SaasNoSupportException;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.SimpleLocalLockComponent;
import com.bcxin.backend.domain.enums.SyncType;
import com.bcxin.backend.domain.repositories.DomainSuperviseRepository;
import com.bcxin.backend.domain.syncs.components.HttpRequestProvider;
import com.bcxin.backend.domain.syncs.dtos.DataSyncParameter;
import com.bcxin.backend.domain.syncs.dtos.SyncDataMeta;
import com.bcxin.backend.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.backend.domain.syncs.services.DataSyncQueueService;
import com.bcxin.backend.domain.syncs.services.impls.DataSyncQueueServiceImpl;
import com.bcxin.runtime.domain.syncs.dtos.FormSyncConfigDto;
import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus;
import com.bcxin.saas.core.components.JsonProvider;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public abstract class DataSyncQueueServiceBase
implements DataSyncQueueService {
    protected static Logger logger = LoggerFactory.getLogger(DataSyncQueueServiceImpl.class);
    protected final DataSyncQueueRepository dataSyncQueueRepository;
    protected final JsonProvider jsonProvider;
    protected final HttpRequestProvider httpRequestProvider;
    protected final AppConfigProperty appConfigProperty;
    protected final StorageProvider storageProvider;
    protected final DomainSuperviseRepository domainSuperviseRepository;
    private final SimpleLocalLockComponent simpleLocalLockComponent;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DataSyncQueueServiceBase(DataSyncQueueRepository dataSyncQueueRepository, JsonProvider jsonProvider, HttpRequestProvider httpRequestProvider, AppConfigProperty appConfigProperty, StorageProvider storageProvider, DomainSuperviseRepository domainSuperviseRepository, SimpleLocalLockComponent simpleLocalLockComponent) {
        this.dataSyncQueueRepository = dataSyncQueueRepository;
        this.jsonProvider = jsonProvider;
        this.httpRequestProvider = httpRequestProvider;
        this.appConfigProperty = appConfigProperty;
        this.storageProvider = storageProvider;
        this.domainSuperviseRepository = domainSuperviseRepository;
        this.simpleLocalLockComponent = simpleLocalLockComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(SyncType syncFile) {
        block27: {
            StringBuilder tracking = new StringBuilder(String.format(" \u5f00\u59cb\u6267\u884c\u5f85\u5904\u7406queues\u6570\u636e: %s;syncFile=%s;", new Object[]{this.getClass().getName(), syncFile}));
            try {
                if (this.simpleLocalLockComponent.enter(this.getClass())) {
                    try {
                        Page<DataSyncQueueEntity> dataSyncQueueEntityPage = null;
                        int pageIndex = 0;
                        boolean hasRecords = false;
                        do {
                            try {
                                Pageable pageable = Pageable.ofSize((int)15);
                                tracking.append(String.format("\u5f00\u59cb\u83b7\u53d6(\u9875\u7801=%s)\u6570\u636e;", pageIndex));
                                ++pageIndex;
                                switch (syncFile) {
                                    case DirectlyData: {
                                        dataSyncQueueEntityPage = this.dataSyncQueueRepository.getPendingData(pageable);
                                        break;
                                    }
                                    case DirectlyFile: {
                                        dataSyncQueueEntityPage = this.dataSyncQueueRepository.getPendingFiles(pageable);
                                        break;
                                    }
                                    case DataViaFtp: {
                                        dataSyncQueueEntityPage = this.dataSyncQueueRepository.getPendingFtpData(pageable);
                                        break;
                                    }
                                    case FileViaFtp: {
                                        dataSyncQueueEntityPage = this.dataSyncQueueRepository.getPendingFtpFilesData(pageable);
                                        break;
                                    }
                                    default: {
                                        throw new SaasNoSupportException();
                                    }
                                }
                                tracking.append(String.format("\u603b\u5171\u83b7\u5f97queues\u8868(%s\u6761)\u6570\u636e;", dataSyncQueueEntityPage == null ? "0" : Long.valueOf(dataSyncQueueEntityPage.getTotalElements())));
                                if (dataSyncQueueEntityPage != null && dataSyncQueueEntityPage.getContent().size() > 0) {
                                    hasRecords = true;
                                    tracking.append(String.format("\u5f00\u59cb\u6267\u884c\u6570\u636e\u540c\u6b65\u9879=%s;", dataSyncQueueEntityPage.getContent().stream().map(ix -> ix.getName()).collect(Collectors.joining(";"))));
                                    Collection dataSyncQueueEntities = null;
                                    try {
                                        dataSyncQueueEntities = dataSyncQueueEntityPage.get().collect(Collectors.toList());
                                        logger.info("\u5f85\u5904\u7406\u7684\u961f\u5217\u5217\u8868: {}({}) !", (Object)dataSyncQueueEntities.stream().map(ix -> String.format("%s=%s", ix.getName(), ix.getId())).collect(Collectors.joining(";")));
                                        dataSyncQueueEntities.parallelStream().forEach(data -> {
                                            StringBuilder executeTracking = new StringBuilder(String.format("[%s]: ", data.getClass().getName()));
                                            executeTracking.append(String.format("\u6b63\u51c6\u5907\u6267\u884c\u5982\u4e0b:%s=%s;", data.getId(), data.getName()));
                                            try {
                                                boolean needSyncFile = syncFile == SyncType.FileViaFtp || syncFile == SyncType.DirectlyFile;
                                                this.executeSyncAction(needSyncFile, (DataSyncQueueEntity)data);
                                                executeTracking.append("\u6570\u636e\u961f\u5217\u6267\u884c\u5b8c\u6bd5!");
                                            }
                                            catch (Exception ex) {
                                                executeTracking.append(String.format("\u6570\u636e\u5f02\u5e38:%s", ex));
                                                logger.error("\u540c\u6b65queues\u8868\u4e2d\u6570\u636e\u5f02\u5e38:{}", (Object)executeTracking);
                                            }
                                            finally {
                                                logger.error(data.getId() + "==" + data.getThirdPartyReferenceId());
                                                this.dataSyncQueueRepository.save(data);
                                            }
                                        });
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        logger.error("DataSyncQueueServiceBase.dispatch()\u65b9\u6cd5\u6267\u884c\u5f85\u5904\u7406queues\u6570\u636e\u8fc7\u7a0b\uff0c\u53d1\u751f\u5f02\u5e38; \u8be6\u7ec6: {}", (Throwable)ex);
                                    }
                                    tracking.append("\u5b8c\u6210\u540c\u6b65\u64cd\u4f5c;");
                                    continue;
                                }
                                hasRecords = false;
                            }
                            catch (Exception ex) {
                                tracking.append(String.format("\u6570\u636e\u5f02\u5e38:%s;", ExceptionUtils.getStackMessage((Throwable)ex)));
                            }
                            finally {
                                logger.error(tracking.toString());
                                tracking = new StringBuilder();
                            }
                        } while (hasRecords);
                        break block27;
                    }
                    finally {
                        this.simpleLocalLockComponent.exit(this.getClass());
                    }
                }
                Calendar calendar = Calendar.getInstance();
                int minute = calendar.get(12);
                int second = calendar.get(13);
                if (minute % 2 == 0 && second % 20 == 0) {
                    logger.error(String.format("%s:\u4efb\u52a1(%s)\u6b63\u5728\u6267\u884c", calendar.getTime(), this.getClass().getName()));
                }
            }
            catch (Exception ex) {
                tracking.append(String.format("\u5f02\u5e38=%s;", ExceptionUtils.getStackMessage((Throwable)ex)));
            }
            finally {
                logger.error("\u6570\u636e\u540c\u6b65\u7684\u64cd\u4f5c:{}", (Object)tracking);
            }
        }
    }

    @Override
    public void dispatch(DataSyncQueueEntity dataSyncQueueEntity) {
        this.executeSyncAction(true, dataSyncQueueEntity);
        this.executeSyncAction(false, dataSyncQueueEntity);
    }

    protected String getFilePathFromJson(JSONObject jsonObject) {
        return jsonObject.getString("path");
    }

    protected String getSyncRealData(DataSyncQueueEntity syncQueueEntity) {
        SyncDataMeta dataMeta = (SyncDataMeta)this.jsonProvider.getData(syncQueueEntity.getData(), SyncDataMeta.class);
        byte[] contentBytes = this.storageProvider.read(dataMeta.getPath());
        String content = new String(contentBytes);
        return content;
    }

    protected HttpResponse executePostRequest(String url, Map<String, Object> headers, String data) {
        return this.httpRequestProvider.post(url, headers, data);
    }

    protected boolean isMatchExecuteCondition(boolean isDispatchFile, DataSyncQueueEntity data) {
        if (data.getSize() == 0) {
            return false;
        }
        return !(!isDispatchFile ? data.getStatus() != SyncProcessStatus.Initialize && data.getStatus() != SyncProcessStatus.SyncViaFTP : data.getFileSyncStatus() != SyncProcessStatus.Initialize && data.getFileSyncStatus() != SyncProcessStatus.SyncViaFTP);
    }

    protected void printBusinessMsg(String msg) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(13) % 30 == 0) {
            logger.error(msg);
        }
    }

    private void executeSyncAction(boolean isDispatchFile, DataSyncQueueEntity data) {
        if (!this.isMatchExecuteCondition(isDispatchFile, data)) {
            logger.error("[{}}] \u672a\u6ee1\u8db3\u6267\u884c\u6761\u4ef6!", (Object)data.getName());
            return;
        }
        FormSyncConfigDto formSyncConfigDto = (FormSyncConfigDto)this.jsonProvider.getData(data.getFormSyncConfig(), FormSyncConfigDto.class);
        StringBuilder sb = new StringBuilder();
        try {
            DataSyncParameter dataSyncParameter = DataSyncParameter.create(data, formSyncConfigDto.getMapKey(), formSyncConfigDto.getTargetConfig(), formSyncConfigDto.getOtherTargetApp());
            sb.append(String.format("\u5b8c\u6210dataSyncParameter:%s;", formSyncConfigDto.getMapKey()));
            if (isDispatchFile) {
                this.executeSyncFileCore(dataSyncParameter);
            } else {
                this.executeSyncDataCore(dataSyncParameter);
            }
            logger.info("[{}}] \u6267\u884c\u5b8c\u6bd5!", (Object)data.getName());
        }
        catch (Exception ex) {
            sb.append(String.format("queues\u8868\u6570\u636e\u540c\u6b65\u5f02\u5e38:id=%s; \u5f02\u5e38=%s", data.getId(), ExceptionUtils.getStackMessage((Throwable)ex)));
            if (isDispatchFile) {
                data.changeFileSyncStatus(SyncProcessStatus.Error, sb.toString());
            }
            data.changeDataSyncStatus(SyncProcessStatus.Error, sb.toString());
        }
    }

    protected abstract void executeSyncDataCore(DataSyncParameter var1);

    protected abstract void executeSyncFileCore(DataSyncParameter var1);

    protected SyncDataMeta saveRequestData(Object requestData) {
        String path = String.format("/uploads/sync/response/ftp/%s-%s.txt", simpleDateFormat.format(new Date()), UUID.randomUUID());
        String data = this.jsonProvider.getJson(requestData);
        byte[] content = data.getBytes(StandardCharsets.UTF_8);
        String realPath = this.storageProvider.save(path, content);
        return SyncDataMeta.create(path, content.length, realPath, Collections.EMPTY_LIST);
    }

    public static void main(String[] args) {
        String aa = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        System.out.println(aa);
    }
}

