package com.baichuanxin.openrestapi.controller;

import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.service.electroncard.ElectronCardService;
import com.baichuanxin.openrestapi.service.NoticeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/apply")
public class OnlineRestController {
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private ElectronCardService electronCardService;
    /**
     * 接受办结通知
     */
    @PostMapping("/getNotice")
    public String getNotice(@RequestBody String noticeData)  {
        noticeService.getNotice(noticeData);
        Map<String,Object> map = new HashMap<>();
        map.put("code",0);
        map.put("msg","请求ID"+noticeData);
        String response = JSON.toJSONString(map);
        return response;
    }

    /**
     * 接受办结通知
     */
    @PostMapping(value="/getResultNotice", produces = "application/json")
    public String getResultNotice(@RequestBody String requestBody) {
        Map<String,Object>  requestBody1 = JSON.parseObject(requestBody,Map.class);
        String taskId = requestBody1.get("taskId").toString();
        noticeService.updateNoticeSentFileStatus(taskId,2);
        Map<String,Object> map = new HashMap<>();
        map.put("code",1);
        map.put("taskID",taskId);
        String response = JSON.toJSONString(map);
        return response;
    }

    @GetMapping(value = "/getElectronCard",produces = "application/json")
    public String getElectronCard(  @RequestHeader("Authorization") String authToken,
                                    @RequestParam String name,
                                    @RequestParam String idCard)  {
        String response=null;
        if (authToken.equals("gafwptdzzz")){
             response = electronCardService.getElectronCard(name, idCard);
        }else {
            Map<String,Object> map = new HashMap<>();
            map.put("code","500");
            map.put("result", "认证失败");
            map.put("baseStr", "false");
            response =  JSON.toJSONString(map);
        }

        return response;
    }

}
