package com.baichuanxin.openrestapi.common.utils;


import cn.hutool.core.convert.NumberChineseFormatter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.configs.OneTaskConfig;
import com.baichuanxin.openrestapi.dtos.*;
import lombok.extern.slf4j.Slf4j;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;


import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import java.io.File;
import java.math.BigDecimal;
import java.util.*;

@Slf4j
@Component
public class OnlineTaskUtil {

    private static String key = "58563214";
    private static String key1 = "32128158";


    @Autowired
    private OneTaskConfig oneTaskConfig;

    /***
     *@Author duxiangyun
     *@Description  构造方法私有化，防止实例化
     *@Date 2024/8/23
     */
    private OnlineTaskUtil(){}

    /**
     *@Author duxiangyun
     *@Description 办件下发确认接口
     *@Date 2024/8/23
     */
    public static boolean taskConfirm(String taskId,Map<String,Object> confirmMap){
        confirmMap.put("taskId",taskId);
        //下发办件确认接口
        HttpResponse execute = HttpUtil.createPost(OnlineTaskConstant.ONE_TASK_CONFIRM).contentType("application/json").body(JSON.toJSONString(confirmMap)).execute();
        if (execute.isOk()){
            String body = execute.body();
            log.info("==================确认响应体{}",body);
            ConfirmDataResultDto confirmDataResultDto = JSON.parseObject(body, ConfirmDataResultDto.class);
            if (confirmDataResultDto.getCode()==200||confirmDataResultDto.getCode()==2002){
                return true;
            }else{
                return false;
            }
        }else  {
            return false;
        }
    }

    /**
     *@Author duxiangyun
     *@Description 根据办件ID获取办件数据接口
     *@Date 2024/8/23
     */
    public static  String getTaskInfo(String taskId){
        List<Map<String ,Object>> listMap = new ArrayList<>();
        //获取办件详情接口
        String taskInfoUrl= "http://65.26.1.31:80/one/task/info?taskId=%s";
        HttpResponse execute = HttpUtil.createGet(String.format(taskInfoUrl, taskId)).contentType("application/json").execute();
        //判断接口是否正常调用
        if (execute.isOk()){
            log.info("=====================办件数据获取接口调用成功==========================");
            String responseBody = execute.body();
            log.info("+++++++++++++++++++获取办件数据响应体{}",responseBody);
            TaskInfoApiResultDto taskInfoApiResultDto = JSON.parseObject(responseBody,TaskInfoApiResultDto.class);
            Map<String, Object> data = taskInfoApiResultDto.getData();
            if (taskInfoApiResultDto.getCode()==200){
                return JSON.toJSONString(data);
            }else {
                //获取结果失败
                log.info("==========================办件数据获取接口调用失败");
                log.info("==========================办件数据获取接口调用失败原因：{}",getStatusText(taskInfoApiResultDto.getCode()));
                log.info("==========================办件数据获取接口调用失败信息：{}",taskInfoApiResultDto.getMsg());
                return "false";
            }
        }else {
            log.info("办件数据获取接口调用失败,taskId:{}",taskId);
        }
        return "false";
    }


    /**
     *@Author duxiangyun
     *@Description 根据办件ID获取办件数据接口
     *@Date 2024/8/23
     */
    public static  String getFeedBack(String taskId){
        List<Map<String ,Object>> listMap = new ArrayList<>();
        //获取办件详情接口
        String taskInfoUrl= "http://65.26.1.31:80/one/task/get-feedback-info?taskId=%s";
        HttpResponse execute = HttpUtil.createGet(String.format(taskInfoUrl, taskId)).contentType("application/json").execute();
        //判断接口是否正常调用
        if (execute.isOk()){
            log.info("=====================办件回执获取接口调用成功==========================");
            String responseBody = execute.body();
            log.info("+++++++++++++++++++获取办件回执响应体{}",responseBody);
            TaskFeedBackDto taskFeedBackDto = JSON.parseObject(responseBody, TaskFeedBackDto.class);
            if (taskFeedBackDto.isSucc()){
                List<Map<String, Object>> data = taskFeedBackDto.getData();
               return JSON.toJSONString(data);
           }else {
               log.info("办件回执获取接口调用失败,响应码:{}",taskFeedBackDto.getMsg());
           }
        }else {
            log.info("办件回执获取接口调用失败,taskId:{}",taskId);
        }
        return "false";
    }

    /***
     *@Author duxiangyun
     *@Description 获取办件回执详情
     *@Date 2024/10/29  
     */
    public static  String getFeedback(String taskId){
        log.info("================获取办件详情回执接口=============");
        log.info("请求task：{}",taskId);
        //获取办件回执详情
        HttpResponse execute = HttpUtil.createPost(OnlineTaskConstant.ONE_TASK_GET_FEEDBACK_FILE)
                .contentType("multipart/form-data;charset=UTF-8")
                .form("taskId",taskId).execute();
        if (execute.isOk()){
            String returnResult = execute.body();
            TaskInfoApiResultDto taskInfoApiResultDto = JSON.parseObject(returnResult, TaskInfoApiResultDto.class);
            return JSON.toJSONString(taskInfoApiResultDto.getData());
        }
        return null;
    }
    /***
     *@Author duxiangyun
     *@Description 返回办件结果
     *@Date 2024/8/26
     */
    public static boolean returnResult(String requestBody){
        log.info("==========================回传办件审批结果=================");
        log.info("请求体：{}",requestBody);
        HttpResponse execute = HttpUtil.createPost(OnlineTaskConstant.ONE_TASK_RESULT).contentType("application/json")
                .body(requestBody).execute();
        if (execute.isOk()){
            String returnResult = execute.body();
            TaskInfoApiResultDto taskInfoApiResultDto = JSON.parseObject(returnResult, TaskInfoApiResultDto.class);
            if (taskInfoApiResultDto.getCode()==200||taskInfoApiResultDto.getCode()==2005){
                return taskInfoApiResultDto.isSucc();
            }else {
                log.info("==========================回传办件审批结果失败=================");
                log.info("回传办件审批结果失败原因：{}",getStatusText(taskInfoApiResultDto.getCode()));
                log.info("回传办件审批结果失败信息：{}",taskInfoApiResultDto.getMsg());
                return false;
            }
        }else{
            return false;
        }
    }

    /**
     * 发送结果物
     * @param
     * @return
     */
    public static boolean returnResultFile(String taskId, String attachName , File file,String specialResultFile ){
        log.info("=========================开始返回结果物===========================");
        log.info("结果物taskId：{}",taskId);
        HttpResponse execute = HttpUtil.createPost(OnlineTaskConstant.ONE_TASK_RESULT_FILE).contentType("multipart/form-data;charset=UTF-8")
                .form("taskId",taskId)
                .form("attachName",attachName)
                .form("file",file)
                .form("specialResultFile",specialResultFile).execute();
        if (execute.isOk()){
            String returnResult = execute.body();
            log.info("发送结果物结果{}",returnResult);
            TaskInfoApiResultDto taskInfoApiResultDto = JSON.parseObject(returnResult, TaskInfoApiResultDto.class);
            if (taskInfoApiResultDto.getCode()==200){
                log.info("=========================结果物返回成功===========================");
                return taskInfoApiResultDto.isSucc();
            }else {
                log.info("=========================结果物返回失败===========================");
                return  false;
            }
        }else {
            log.info("=========================请求返回结果物失败===========================");
            return  false;
        }
    }



    /***
     *@Author duxiangyun
     *@Description   数据解密
     *@Date 2024/8/28
     */
    public static String decrypt(String message) {
        try {
//            System.out.println("decrypt:" + message);
            log.info("============================开始数据解密================================");
            byte[] bytesrc = new BASE64Decoder().decodeBuffer(message);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            DESKeySpec desKeySpec = new DESKeySpec(key.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(key1.getBytes("UTF-8"));
            cipher.init(Cipher.DECRYPT_MODE, secretKey, iv);
            byte[] retByte = cipher.doFinal(bytesrc);
            log.info("============================数据解密完成================================");
            return new String(retByte);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String convertStatus(String status) {
        switch (status){
            case "0":
                return "NG";
            case "1":
                return "OK";
            case "OK":
                return "通过";
            case "NG":
                return "退回";
        }
        return status;
    }
    /**
     * @Description  一网通办平台响应码
     * @param statusCode
     * @return
     */
    public static String  getStatusText(int statusCode) {
        switch (statusCode) {
            case 200:
                return "请求成功";
            case 1001:
                return "缺少请求参数";
            case 1002:
                return "请求参数解析异常";
            case 1003:
                return "参数校验异常";
            case 2002:
                return "办件已下发，请勿重复确认";
            case 2003:
                return "审批过程中信息保存失败";
            case 2004:
                return "审批结果信息保存失败";
            case 2005:
                return "该办件已办结或退回";
            case 9999:
                return "系统异常";
            default:
                return StrUtil.toString(statusCode);
        }
    }
    /***
     *@Author duxiangyun
     *@Description 经营范围格式化
     *@Date 2024/9/21
     */
    public static   String  scopConvert(List<String> strings){
        String s = strings.toString()
                .replace(",",";")
                .replace("[","")
                .replace("]","")
                .replace(" ","")
                .replace("\"","");
        return s;
    }

    /***
     *@Author duxiangyun
     *@Description   政治面貌转换
     *@Date 2024/10/8
     */
    public static   String  identConvert(String s){
        switch (s){
            case "01":
                return "中共党员";
            case "02":
                return "中共预备党员";
            case "03":
                return "共青团员";
            case "04":
                return "民革会员";
            case "05":
                return "民盟盟员";
            case "06":
                return "明建会员";
            case "07":
                return "民进会员";
            case "08":
                return "农工党党员";
            case "09":
                return "致公党党员";
            case "10":
                return "九三学社社员";
            case "11":
                return "台盟盟员";
            case "12":
                return "无党派民主人士";
            case "13":
                return "群众";
            default:
                return "其他";
        }
    }
    /***
     *@Author duxiangyun
     *@Description   文化程度转换
     *@Date 2024/10/8
     */
    public static   String  eduConvert(String s){
        switch (s){
            case "1":
                return "8";
            case "2":
                return "7";
            case "3":
                return "大学本科";
            case "4":
                return "5";
            case "6":
                return "4";
            case "8":
                return "3";
            case "9":
                return "2";
            case "10":
                return "1";
            default:
                return "其他";
        }
    }

    /***
     *@Author duxiangyun
     *@Description   职务
     *@Date 2024/10/8
     */
    public static   String  jobConvert(String s){
        switch (s){
            case "1":
                return "总经理";
            case "2":
                return "副总经理";
            case "3":
                return "法定代表人";
            case "4":
                return "法定代表人兼总经理";
            default:
                return "其他";
        }
    }
    /***
     *@Author duxiangyun
     *@Description   身份证类型
     *@Date 2024/10/8
     */
    public static   String  idCardTypeConvert(String s){
        switch (s){
            case "111":
                return "0";  //居民身份证
            case "113":
                return "0";   //户口簿
            default:
                return "其他";
        }
    }

    /***
     *@Author duxiangyun
     *@Description   身份证类型
     *@Date 2024/10/8
     */
    public static   String  idCardType2Convert(String s){
        switch (s){
            case "111":
                return "1";  //居民身份证
            case "113":
                return "1";   //户口簿
            default:
                return "其他";
        }
    }
    /**
     * 服务范围格式化
     * @return
     */
    public static String strHandle(String data){
        StringBuffer stringBuffer =new StringBuffer();
        String[] split = data.split(";");
        List<String> strList = Arrays.asList(split);
        for (int i = 0; i < strList.size(); i++) {
            switch (strList.get(i)){
                case "01":
                    stringBuffer.append("门卫，");
                    break;
                case "02":
                    stringBuffer.append("巡逻，");
                    break;
                case "03":
                    stringBuffer.append("守护，");
                    break;
                case "04":
                    stringBuffer.append("押运，");
                    break;
                case "05":
                    stringBuffer.append("随身护卫，");
                    break;
                case "06":
                    stringBuffer.append("安全检查，");
                    break;
                case "08":
                    stringBuffer.append("安全风险评估，");
                    break;
                case "09":
                    stringBuffer.append("安全技术防范,");
                    break;
                default:
                    stringBuffer.append("");
                    break;
            }

        }
        String str  =  stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
        return str;
    }

    /**
     * xml 数据处理
     */
    public static String  handleXml(Map<String,String>  stringMap  ){
//         List<Map<String ,String >> mapList  =new ArrayList<>();
//        Map<String, String > map = new HashMap<>();
//        map.put("XM", "项目");
//        map.put("BG", "变更");
//        map.put("SJ", "时间");
//        map.put("YZ", "印章");
//        mapList.add(map);
        String  dataXml  =  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<license>\n" +
                "    <catalog catalogId=\"2fcd6fca68bf46709b5983151af86272\" catalogName=\"保安服务许可证\" templateId=\"43d6d300ff7741338489d24354df48ba\" templateName=\"保安服务许可证模板\" version=\"2024V2.0\"/>\n" +
                "    <surface>\n" +
                "        <item alias=\"whose\" name=\"证照归属\" require=\"1\" value=\"\"/>\n" +
                "        <item alias=\"holderCodeType\" code=\"certificateHolderTypeCode\" name=\"证件类型\" require=\"1\" value=\"\"/>\n" +
                "        <item alias=\"issueUnitname\" catetype=\"0\" code=\"certificateIssuingAuthorityName\" name=\"颁证单位\" require=\"1\" type=\"banzhengdanwei\" value=\"湖南省公安厅\"/>\n" +
                "        <item alias=\"licenseNumber\" catetype=\"0\" code=\"certificateNumber\" name=\"证照编号\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"issueDate\" catetype=\"0\" code=\"certificateIssuedDate\" dateFormat=\"yyyy-MM-dd\" name=\"颁证时间\" require=\"1\" type=\"riqi\" value=\"\"/>\n" +
                "        <item alias=\"validTimeBegin\" catetype=\"0\" code=\"certificateEffectiveDate\" dateFormat=\"yyyy-MM-dd\" name=\"有效期（起始）\" require=\"0\" type=\"riqi\" value=\"\"/>\n" +
                "        <item alias=\"holder\" catetype=\"0\" code=\"certificateHolderName\" name=\"持证者\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"validTimeEnd\" catetype=\"0\" code=\"certificateExpiringDate\" dateFormat=\"yyyy-MM-dd\" name=\"有效期（截止）\" require=\"0\" type=\"riqi\" value=\"\"/>\n" +
                "        <item alias=\"holderCode\" catetype=\"0\" code=\"certificateHolderCode\" name=\"统一社会信用代码\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"ZS\" catetype=\"1\" code=\"KZ_ZS\" name=\"住所\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"FDDBR\" catetype=\"1\" code=\"KZ_FDDBR\" name=\"法定代表人\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"FWFW\" catetype=\"1\" code=\"KZ_FWFW\" name=\"服务范围\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"ZCZB\" catetype=\"1\" code=\"KZ_ZCZB\" name=\"注册资本\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"PZWH\" catetype=\"1\" code=\"KZ_PZWH\" name=\"批准文号\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"MJXM\" catetype=\"1\" code=\"KZ_MJXM\" name=\"民警姓名\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"MJSFZHM\" catetype=\"1\" code=\"KZ_MJSFZHM\" name=\"民警身份证号码\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"MJJH\" catetype=\"1\" code=\"KZ_MJJH\" name=\"民警警号\" require=\"0\" type=\"string\" value=\"\"/>\n" +
                "        <item alias=\"YHID\" catetype=\"1\" code=\"KZ_YHID\" name=\"用户Id\" require=\"1\" type=\"string\" value=\"\"/>\n" +
                "    </surface>\n" +
                "    <detail>\n" +
                "        <items sort=\"0\">\n" +
                "            <item alias=\"XM\" code=\"KZ_XM\" name=\"项目\" require=\"1\" rowNo=\"0\" type=\"string\" value=\"\"/>\n" +
                "            <item alias=\"BG\" code=\"KZ_BG\" name=\"变更\" require=\"1\" rowNo=\"0\" type=\"string\" value=\"\"/>\n" +
                "            <item alias=\"SJ\" code=\"KZ_SJ\" name=\"时间\" require=\"1\" rowNo=\"0\" type=\"string\" value=\"\"/>\n" +
                "            <item alias=\"YZ\" code=\"KZ_YZ\" name=\"印章\" require=\"1\" rowNo=\"0\" type=\"string\" value=\"\"/>\n" +
                "        </items>\n" +
                "    </detail>\n" +
                "</license>";
        Document document = null;
        try {
            document = DocumentHelper.parseText(dataXml);
            Element rootElement = document.getRootElement();
            Element surface = rootElement.element("surface");
            List<Element> itemElementList = surface.elements("item");
            itemElementList.get(0).attribute("value").setValue("0");  //0 代表法人身份证号
            itemElementList.get(1).attribute("value").setValue("001");
            itemElementList.get(2).attribute("value").setValue("湖南省公安厅");    //颁证单位填充值
            itemElementList.get(3).attribute("value").setValue(stringMap.get("licenseNumber").substring(4,11));       //证照编号
            itemElementList.get(4).attribute("value").setValue(stringMap.get("issueDate"));
            itemElementList.get(5).attribute("value").setValue(stringMap.get("issueDate"));
            itemElementList.get(6).attribute("value").setValue(stringMap.get("holder"));
            itemElementList.get(7).attribute("value").setValue("2199-01-01 00:00:00");
            itemElementList.get(8).attribute("value").setValue(stringMap.get("holderCode"));
            itemElementList.get(9).attribute("value").setValue(stringMap.get("zs"));
            itemElementList.get(10).attribute("value").setValue(stringMap.get("fddbr"));
            itemElementList.get(11).attribute("value").setValue(stringMap.get("fwfw"));
            double v = Double.parseDouble(stringMap.get("zczb"));
            String zczb = NumberChineseFormatter.format(v,true,false);
            itemElementList.get(11).attribute("value").setValue(String.join("",zczb,"万元人民币"));
            itemElementList.get(12).attribute("value").setValue(stringMap.get("pzwh"));
            itemElementList.get(13).attribute("value").setValue("杜湘云");
            itemElementList.get(14).attribute("value").setValue("430581200012137314");
            itemElementList.get(16).attribute("value").setValue("134132");

//            for (int i = 0; i < mapList.size(); i++) {   法人变更数据补充
//                Map<String, String> map1 = mapList.get(i);
//                Element detailElement = rootElement.element("detail");
//                Element items = detailElement.addElement("items").addAttribute("sort", String.valueOf(i));
//                items.addElement("item").addAttribute("alias","XM").addAttribute("code","KZ_XM")
//                        .addAttribute("name","项目").addAttribute("require","1").addAttribute("rowNo","0")
//                        .addAttribute("type","string").addAttribute("value",map1.get("XM"));
//                items.addElement("item").addAttribute("alias","BG").addAttribute("code","KZ_BG")
//                        .addAttribute("name","变更").addAttribute("require","1").addAttribute("rowNo","0")
//                        .addAttribute("type","string").addAttribute("value",map1.get("BG"));
//                items.addElement("item").addAttribute("alias","SJ").addAttribute("code","KZ_SJ")
//                        .addAttribute("name","时间").addAttribute("require","1").addAttribute("rowNo","0")
//                        .addAttribute("type","string").addAttribute("value",map1.get("SJ"));
//                items.addElement("item").addAttribute("alias","YZ").addAttribute("code","KZ_YZ")
//                        .addAttribute("name","印章").addAttribute("require","1").addAttribute("rowNo","0")
//                        .addAttribute("type","string").addAttribute("value",map1.get("YZ"));
//
//            }
        } catch (DocumentException e) {
            e.printStackTrace();
        }
        return document.asXML();
    }
    /**
     * 提交照面信息至第三方
     * unId  证照的唯一标识，采用证照的编号用做唯一标识，  或者申请数据的id  待商榷
     */
    public static Map<String,String> xmlDataSend(String xmlData,String unId,String eCToken){
        Map<String ,String >  map   = new HashMap<>();
        String xmlDataSendUrl = "http://65.26.106.115:8003/license-api-release/m/v2/license/license_info/save";
        Map<String ,Object>  formDataMap= new  HashMap<>();
        formDataMap.put("access_token",eCToken);
        formDataMap.put("xml",xmlData);
        formDataMap.put("unid",unId);
        formDataMap.put("state","2");
        HttpResponse execute = HttpUtil.createPost(xmlDataSendUrl).header("Content-Type", "application/x-www-form-urlencoded")
                .form(formDataMap).execute();
        log.info("提交照面信息请求参数{}", JSON.toJSONString(formDataMap));
        int status = execute.getStatus();
        log.error("照面信息提交请求状态码：{}，",status);
        String responseBody = execute.body();
        if (status==200){
            JSONObject jsonObject = JSON.parseObject(responseBody);
            String head = jsonObject.getString("head");
            JSONObject jsonHead = JSON.parseObject(head);
            String headStatus = jsonHead.getString("status");
            log.error("响应体返回状态码{}",status,headStatus);
            log.error("提交照面信息返回值{}",responseBody);
            if(headStatus.equals("0")){    //如果报错了就不要保存了
                String data = jsonObject.getString("data");
                JSONObject jsonData = JSON.parseObject(data);
                String fileNumber = jsonData.getString("fileNumber");
                String licenseId = jsonData.getString("licenseId");
                map.put("fileNumber",fileNumber);
                map.put("licenseId",licenseId);
            }
        }
        return map ;
    }

    public static int  updateXmlDataSend(String eCToken,String licenseId,String xmlData,String unId){
        Map<String ,String >  map   = new HashMap<>();
        String updateXmlDataSendUrl = "http://65.26.106.115:8003/license-api-release/m/v2/license/change";
        Map<String ,Object>  formDataMap= new  HashMap<>();
        formDataMap.put("access_token",eCToken);
        formDataMap.put("licenseId",licenseId);
        formDataMap.put("xml",xmlData);
        formDataMap.put("unid",unId);
        formDataMap.put("state","2");  // 2 为自动签章 1为手动签章
        HttpResponse execute = HttpUtil.createPost(updateXmlDataSendUrl).header("Content-Type", "application/x-www-form-urlencoded")
                .form(formDataMap).execute();
        log.info("提交照面信息请求参数{}", JSON.toJSONString(formDataMap));
        log.info("法人变更二次提交变更响应体{}",execute.body());
        if (execute.isOk()){
            Map<String,Object> objectMap= JSON.parseObject(execute.body(),Map.class);
            String jsonString = JSON.toJSONString(objectMap.get("head"));
            Map<String,Object> headMap= JSON.parseObject(jsonString,Map.class);
            int status =  (Integer)headMap.get("status");
            log.info("变更电子证照数据调用结果:message{},状态{}",status);
            return status;
        }else {
            log.info("变更电子证照数据调用失败");
            return -1;
        }
    }

    //获取证照的base64编码
    public static String getFileRequest(String  fileNumber){
        String  url  = "http://65.26.106.115:8003/license-api-release/license/national/downloadfile";
        Map<String ,Map<String,String>>  requestMap =  new  HashMap<>();
        Map<String,String>  dataMap = new HashMap<>();
        dataMap.put("certificateIdentifier",fileNumber);
        requestMap.put("head",new HashMap<>());
        requestMap.put("data",dataMap);
        String requestJson = JSON.toJSONString(requestMap);
        String fileStr ="";
        HttpResponse response = HttpUtil.createPost(url).body(requestJson).execute();
        String responseBody = response.body();
        //解析响应体
        Map<String,Map<String,Object>> responseMap = JSON.parseObject(responseBody, Map.class);
        Map<String, Object> head = responseMap.get("head");
        String status = head.get("status").toString();
        if (status.equals("0")){  //状态为0 说明文件已经盖章完成 、为其它值说明文件还没生成。
            Map<String, Object> data = responseMap.get("data");
            fileStr = data.get("content").toString();
        }
        return  fileStr;
    }

    public static String removeTrailingZeros(String number) {
        // 使用正则表达式去除小数点后的无效零
        return number.replaceAll("0+(?=[^\\.]*\\.)", "");
    }
}
