/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import com.bcxin.tenant.open.infrastructures.utils.PoliceEventCategoryUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

@Schema(name="PoliceIncidentOverviewResponse", title="PoliceIncidentOverviewResponse \u8b66\u60c5\u4e0a\u62a5\u8be6\u60c5\u4fe1\u606f")
public class PoliceIncidentOverviewResponse
extends ResponseAbstract {
    @Schema(name="id", title="id")
    private final String id;
    @Schema(name="tenantUserId", title="\u4eba\u5458ID")
    private final String tenantUserId;
    @Schema(name="tenantUserName", title="\u59d3\u540d")
    private final String tenantUserName;
    @Schema(name="idNumber", title="\u8eab\u4efd\u8bc1\u53f7")
    private final String idNumber;
    @Schema(name="tenantEmployeeId", title="\u96c7\u5458ID")
    private final String tenantEmployeeId;
    @Schema(name="organizationId", title="\u4f01\u4e1aID")
    private final String organizationId;
    @Schema(name="organizationName", title="\u4f01\u4e1a\u540d\u79f0")
    private final String organizationName;
    @Schema(name="securityStationId", title="\u9a7b\u52e4\u70b9ID")
    private final String securityStationId;
    @Schema(name="securityStationName", title="\u9a7b\u52e4\u70b9\u540d\u79f0")
    private final String securityStationName;
    @Schema(name="securityStationAddress", title="\u9a7b\u52e4\u70b9\u5730\u5740")
    private final String securityStationAddress;
    @Schema(name="superviseDepartId", title="\u76d1\u7ba1\u673a\u6784ID")
    private final String superviseDepartId;
    @Schema(name="superviseDepartName", title="\u76d1\u7ba1\u673a\u6784\u540d\u79f0")
    private final String superviseDepartName;
    @Schema(name="code", title="\u4e8b\u4ef6\u7f16\u7801")
    private final String code;
    @Schema(name="name", title="\u4e8b\u4ef6\u6807\u9898")
    private final String name;
    @Schema(name="empName", title="\u96c7\u5458\u540d\u79f0")
    private final String empName;
    @Schema(name="sceneUrl", title="\u73b0\u573a\u56fe\u7247")
    private final String sceneUrl;
    @Schema(name="contact", title="\u8054\u7cfb\u7535\u8bdd")
    private final String contact;
    @Schema(name="policeEventStatus", title="\u5904\u7406\u72b6\u6001\uff1aNone \u5f85\u5904\u7406\uff0cPending \u5904\u7406\u4e2d\uff0cOver \u5df2\u5904\u7406")
    private final String policeEventStatus;
    @Schema(name="policeEventLevel", title="\u4e8b\u4ef6\u7ea7\u522b\uff1aComon \u4e00\u822c\uff0cMore \u8f83\u5927\uff0cGreat \u91cd\u5927\uff0cGreats \u7279\u522b\u91cd\u5927")
    private final String policeEventLevel;
    @Schema(name="address", title="\u4e8b\u4ef6\u5730\u5740/\u8b66\u60c5\u4e0a\u62a5\u7684\u5730\u5740")
    private final String address;
    @Schema(name="reason", title="\u4e8b\u4ef6\u8d77\u56e0")
    private final String reason;
    @Schema(name="policeEventType", title="\u4e8b\u4ef6\u7c7b\u578b")
    private final String policeEventType;
    @Schema(name="category", title="\u4e8b\u4ef6\u7c7b\u522b")
    private final PoliceEventCategory category;
    @Schema(name="latitude", title="\u7eac\u5ea6 y")
    private final double latitude;
    @Schema(name="longitude", title="\u7ecf\u5ea6 x")
    private final double longitude;
    @Schema(name="actionTaken", title="\u5df2\u91c7\u53d6\u63aa\u65bd/sos\u7684\u5904\u7406\u8bf4\u660e")
    private final String actionTaken;
    @Schema(name="actionTendency", title="\u53d1\u5c55\u8d8b\u52bf")
    private final String actionTendency;
    @Schema(name="processedSuggestion", title="\u516c\u5b89\u5efa\u8bae")
    private final String processedSuggestion;
    @Schema(name="processedLocaleGuidance", title="\u73b0\u573a\u6307\u5bfc\u610f\u89c1")
    private final String processedLocaleGuidance;
    @Schema(name="processedUserId", title="\u5904\u7406\u4eba(\u516c\u5b89)id")
    private final String processedUserId;
    @Schema(name="processedUserName", title="\u5904\u7406\u4eba(\u516c\u5b89)\u59d3\u540d")
    private final String processedUserName;
    @Schema(name="processedTime", title="\u5904\u7406\u65f6\u95f4")
    private final String processedTime;
    @Schema(name="createdTime", title="\u521b\u5efa\uff08\u62a5\u6848\uff09\u65f6\u95f4/Sos\u7684\u64cd\u4f5c\u65f6\u95f4/\u4e0a\u62a5\u65f6\u95f4")
    private final String createdTime;
    @Schema(name="description", title="\u4e8b\u4ef6\u8bf4\u660e")
    private final String description;
    @Schema(name="location", title="\u62a5\u8b66\u5730\u5740")
    private final String location;
    @Schema(name="projectId", title="\u9879\u76eeId")
    private final String projectId;
    @Schema(name="projectName", title="\u9879\u76ee\u540d\u79f0")
    private final String projectName;

    public PoliceIncidentOverviewResponse(String id, PoliceEventCategory category, String tenantUserId, String tenantUserName, String tenantEmployeeId, String idNumber, String organizationId, String organizationName, String securityStationId, String securityStationName, String superviseDepartId, String superviseDepartName, String code, String name, String empName, String sceneUrl, String contact, PoliceEventStatus eventStatus, PoliceEventLevel eventLevel, String address, String reason, int eventType, double latitude, double longitude, String actionTaken, String actionTendency, String processedSuggestion, String processedLocaleGuidance, String processedUserId, String processedUserName, Timestamp processedTime, Timestamp createdTime, String securityStationAddress, String description, String location, String projectId, String projectName) {
        this.id = id;
        this.category = category;
        this.tenantUserId = tenantUserId;
        this.tenantUserName = tenantUserName;
        this.tenantEmployeeId = tenantEmployeeId;
        this.organizationId = organizationId;
        this.organizationName = organizationName;
        this.securityStationId = securityStationId;
        this.superviseDepartId = superviseDepartId;
        this.idNumber = idNumber;
        this.securityStationAddress = securityStationAddress;
        this.superviseDepartName = "#1".equals(superviseDepartName) ? "" : superviseDepartName;
        this.securityStationName = "#1".equals(securityStationName) ? "" : securityStationName;
        this.code = code;
        this.name = name;
        this.empName = empName;
        this.sceneUrl = sceneUrl;
        this.contact = contact;
        this.policeEventStatus = eventStatus.getTypeName();
        this.policeEventLevel = eventLevel.getTypeName();
        this.address = address;
        this.reason = reason;
        this.policeEventType = PoliceEventCategoryUtils.getEventTypeName((PoliceEventCategory)category, (int)eventType);
        this.latitude = latitude;
        this.longitude = longitude;
        this.actionTaken = actionTaken;
        this.actionTendency = actionTendency;
        this.processedSuggestion = processedSuggestion;
        this.processedLocaleGuidance = processedLocaleGuidance;
        this.processedUserId = processedUserId;
        this.processedUserName = processedUserName;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.processedTime = processedTime != null ? dateFormat.format(processedTime) : null;
        this.createdTime = dateFormat.format(createdTime);
        this.description = description;
        this.location = location;
        this.projectId = projectId;
        this.projectName = projectName;
    }

    public static PoliceIncidentOverviewResponse create(String id, PoliceEventCategory category, String tenantUserId, String tenantUserName, String tenantEmployeeId, String idNumber, String organizationId, String organizationName, String securityStationId, String securityStationName, String superviseDepartId, String superviseDepartName, String code, String name, String empName, String sceneUrl, String contact, PoliceEventStatus eventStatus, PoliceEventLevel eventLevel, String address, String reason, int eventType, double latitude, double longitude, String actionTaken, String actionTendency, String processedSuggestion, String processedLocaleGuidance, String processedUserId, String processedUserName, Timestamp processedTime, Timestamp createdTime, String securityStationAddress, String description, String location, String projectId, String projectName) {
        return new PoliceIncidentOverviewResponse(id, category, tenantUserId, tenantUserName, tenantEmployeeId, idNumber, organizationId, organizationName, securityStationId, securityStationName, superviseDepartId, superviseDepartName, code, name, empName, sceneUrl, contact, eventStatus, eventLevel, address, reason, eventType, latitude, longitude, actionTaken, actionTendency, processedSuggestion, processedLocaleGuidance, processedUserId, processedUserName, processedTime, createdTime, securityStationAddress, description, location, projectId, projectName);
    }

    public String getId() {
        return this.id;
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public String getTenantUserName() {
        return this.tenantUserName;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public String getTenantEmployeeId() {
        return this.tenantEmployeeId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getSecurityStationId() {
        return this.securityStationId;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public String getSecurityStationAddress() {
        return this.securityStationAddress;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getEmpName() {
        return this.empName;
    }

    public String getSceneUrl() {
        return this.sceneUrl;
    }

    public String getContact() {
        return this.contact;
    }

    public String getPoliceEventStatus() {
        return this.policeEventStatus;
    }

    public String getPoliceEventLevel() {
        return this.policeEventLevel;
    }

    public String getAddress() {
        return this.address;
    }

    public String getReason() {
        return this.reason;
    }

    public String getPoliceEventType() {
        return this.policeEventType;
    }

    public PoliceEventCategory getCategory() {
        return this.category;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getActionTaken() {
        return this.actionTaken;
    }

    public String getActionTendency() {
        return this.actionTendency;
    }

    public String getProcessedSuggestion() {
        return this.processedSuggestion;
    }

    public String getProcessedLocaleGuidance() {
        return this.processedLocaleGuidance;
    }

    public String getProcessedUserId() {
        return this.processedUserId;
    }

    public String getProcessedUserName() {
        return this.processedUserName;
    }

    public String getProcessedTime() {
        return this.processedTime;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

