package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.mapper.ComTaskAttendAddressMapper;
import com.bcxin.oa.old.entity.task.ComTaskAttendAddress;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.Result;
import com.github.pagehelper.StringUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 任务考勤地址
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
@Service
@Transactional
public class ComTaskAttendAddressServiceImpl implements ComTaskAttendAddressService {
    @Resource
    private ComTaskAttendAddressMapper comTaskAttendAddressMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 任务-出勤设置-出勤地点-删除
     *
     * @param comTaskAttendAddress
     * @return
     * @author zhangjianhua
     * @update by llc 2019-11-27
     * @date 2018/03/02
     */
    @Override
    public Result deleteComTaskAttendAddress(ComTaskAttendAddress comTaskAttendAddress) throws BusinessException {

        if (comTaskAttendAddressMapper.deleteByTaskAttendAddressId(comTaskAttendAddress) != 1) {
            throw new BusinessException(Result.BUSINESS_ERROR, "删除出勤地点失败，请重试");

        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 任务-出勤设置-出勤地点-新增
     *
     * @param comTaskAttendAddress
     * @return
     * @author zhangjianhua
     * @update by llc 2019-11-27
     * @date 2018/03/02
     */
    @Override
    public Result addComTaskAttendAddress(ComTaskAttendAddress comTaskAttendAddress) throws BusinessException {

        if (comTaskAttendAddress.getComTaskId() == null) {
            return Result.fail("任务ID不能为空");
        }
        if (StringUtil.isEmpty(comTaskAttendAddress.getAddress())) {
            return Result.fail("考勤地址不能为空");
        }
        if (StringUtil.isEmpty(comTaskAttendAddress.getAddressLongitude())) {
            return Result.fail("考勤地址经度不能为空");
        }
        if (StringUtil.isEmpty(comTaskAttendAddress.getAddressLatitude())) {
            return Result.fail("考勤地址纬度不能为空");
        }
        comTaskAttendAddress.setTaskAttendAddressId(idWorker.nextId());
        int status = comTaskAttendAddressMapper.insert(comTaskAttendAddress);
        if (status <= 0) {
            throw new BusinessException(Result.BUSINESS_ERROR, "新增出勤地点失败，请重试");
        }
        return Result.success("新增成功");
    }

    /**
     * 任务-出勤设置-出勤地点-修改
     *
     * @param comTaskAttendAddress
     * @update by llc 2019-11-27
     * @throws BusinessException
     */
    @Override
    public Result updateComTaskAttendAddress(ComTaskAttendAddress comTaskAttendAddress) throws BusinessException {

        if (comTaskAttendAddress.getTaskAttendAddressId() == null) {
            return Result.fail("任务考勤地址ID不能为空");
        }
        if (StringUtil.isEmpty(comTaskAttendAddress.getAddress())) {
            return Result.fail("考勤地址不能为空");
        }
        if (StringUtil.isEmpty(comTaskAttendAddress.getAddressLongitude())) {
            return Result.fail("考勤地址经度不能为空");
        }
        if (StringUtil.isEmpty(comTaskAttendAddress.getAddressLatitude())) {
            return Result.fail("考勤地址纬度不能为空");
        }
        // 更新地出勤地点
        comTaskAttendAddressMapper.update(comTaskAttendAddress);
        return Result.success("修改成功");

    }

    /**
     * 任务-出勤设置-出勤地点-列表
     *
     * @param comTaskId
     * @return
     */
    @Override
    public Result listComTaskAttendAddress(Long comTaskId) {
        if (comTaskId == null || comTaskId.toString() == "") {
            return Result.fail("comTaskId");
        }

        List<ComTaskAttendAddress> list = comTaskAttendAddressMapper.listComTaskAttendAddress(comTaskId);
        return Result.success("出勤地点列表：", list);
    }

}