package com.bcxin.oa.old.service.salary.web;

import cn.hutool.core.lang.Console;
import cn.hutool.core.text.StrSplitter;
import com.bcxin.oa.old.mapper.salary.ComSalaryTempMapper;
import com.bcxin.oa.old.mapper.salary.ComSalaryTempPerMapper;
import com.bcxin.oa.old.mapper.salary.ComSalaryTempProjectMapper;
import com.bcxin.oa.old.entity.salary.ComSalaryTemp;
import com.bcxin.oa.old.entity.salary.ComSalaryTempProject;
import com.bcxin.oa.old.entity.salary.ConfigSalaryType;
import com.bcxin.oa.old.dto.salary.ComSalaryTempDTO;
import com.bcxin.oa.old.dto.salary.ComSalaryTempProjectDTO;
import com.bcxin.oa.old.dto.salary.ConfigSalaryCategoryDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.CommonConst;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * 企业薪酬模板
 *
 * @author llc
 * @date 2018-12-28
 */
@Service
@Transactional
public class ComSalaryTempServiceImpl implements ComSalaryTempService {

    @Resource
    private ComSalaryTempMapper comSalaryTempMapper;

    @Resource
    private ComSalaryTempPerMapper comSalaryTempPerMapper;

    @Resource
    private ComSalaryTempProjectMapper comSalaryTempProjectMapper;

    @Resource
    private IdWorker idWorker;
    /**
     * 获取薪酬项目配置
     *
     * @return
     * @author llc
     * @date 2018-12-28
     */
    @Override
    public Result getConfigSalaryType() throws BusinessException {
        List<ConfigSalaryCategoryDTO> categoryList = comSalaryTempMapper.getConfigSalaryCategory();
        List<ConfigSalaryType> typeList = comSalaryTempMapper.getConfigSalaryType();
        /*** 把薪资项目放入薪资范畴列表 ***/
        for (ConfigSalaryCategoryDTO dto : categoryList) {
            List<ConfigSalaryType> salaryTypeList = new ArrayList<>();
            for (ConfigSalaryType salaryType : typeList) {
                if (salaryType.getSalaryCategory().equals(dto.getSalaryCategory())) {
                    salaryTypeList.add(salaryType);
                }
            }
            dto.setSalaryTypeList(salaryTypeList);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, categoryList);
    }

    /**
     * 校验模板人员是否存在其他模板
     *
     * @param comSalaryTemp
     * @param perList
     * @return
     * @author llc
     * @date 2019-01-03
     */
    @Override
    public Result checkSalaryTempPer(ComSalaryTemp comSalaryTemp, String perList) throws BusinessException {
        List<String> perIdList = StrSplitter.split(perList, ",", true, true);
        if (perIdList.size() == 0) {
            return Result.fail("薪酬模板必须选择人员");
        }
        List<String> existsPerList = comSalaryTempPerMapper.checkSalaryTempPer(comSalaryTemp.getComId(),
                comSalaryTemp.getComSalaryTempId(),
                comSalaryTemp.getStartYears(),
                comSalaryTemp.getEndYears(),
                perIdList);
        Map<String, Object> result = new HashMap<>();
        if (existsPerList.size() > 0) {
            result.put("existsPerList", existsPerList);
        }else{
            result.put("existsPerList", null);
        }
        return Result.success("", result);
    }


    /**
     * 保存企业薪酬模板接口
     *
     * @return
     * @author llc
     * @date 2018-12-28
     */
    @Override
    public Result saveComSalaryTemp(ComSalaryTemp comSalaryTemp, Map<String, String> requestMap) throws BusinessException {
        //ComSalaryTempDTO dto = JSON.parseObject(paramDTO.getDetail(), ComSalaryTempDTO.class);

        /*** 校验是否存在重名的薪资模板 ***/
         int count = comSalaryTempMapper.checkSameNameSalaryTemp(comSalaryTemp);
         if(count > 0){
             return Result.fail("已存在名为: "+comSalaryTemp.getName()+"的模板，请修改模板名称！");
         }

        /*** 新增薪酬模板 ***/
        if (comSalaryTemp.getComSalaryTempId() == null) {

            Long comSalaryTempId = idWorker.nextId();
            comSalaryTemp.setComSalaryTempId(comSalaryTempId);
            comSalaryTempMapper.insertComSalaryTemp(comSalaryTemp);

            /* 薪酬报表对应项目 ***/
            Map<String, ComSalaryTempProject> projectMap = Maps.newHashMap();
            for (String key : requestMap.keySet()) {
                /* 先处理五险一金的项 */
                if (key.endsWith("_five")) {
                    String value = requestMap.get(key);
                    if (CommonConst.N.equals(value)) {
                        continue;
                    }
                }
                if (!(key.endsWith("_amount") || key.endsWith("_remark") || key.endsWith("_five"))) {
                    continue;
                }
                Console.log("处理的attr：" + key);
                String newKey = CharMatcher.digit().retainFrom(key);
                ComSalaryTempProject project;
                if (projectMap.get(newKey) == null) {
                    project = new ComSalaryTempProject();
                    project.setComSalaryTempId(comSalaryTemp.getComSalaryTempId());
                    project.setCreateTime(comSalaryTemp.getCreateTime());
                    project.setCreateBy(comSalaryTemp.getCreateBy());
                    project.setSalaryType(newKey);
                    project.setSetAmount(0L);
                } else {
                    project = projectMap.get(newKey);
                }
                if (key.endsWith("_amount") && StringUtil.isNotEmpty(requestMap.get(key))) {
                    project.setSetAmount(Long.parseLong(requestMap.get(key)));
                } else if (key.endsWith("_remark")) {
                    project.setRemark(requestMap.get(key));
                }
                projectMap.put(newKey, project);

            }
            if (projectMap.size() > 0) {
                comSalaryTempProjectMapper.batchInsertSalaryTempProject(new ArrayList<>(projectMap.values()));
            }

            /*** 薪酬报表对应人员 ***/

            List<String> perIdList = StrSplitter.split(requestMap.get("perList"), ",", true, true);
            if (perIdList.size() == 0) {
                return Result.fail("薪酬模板必须选择人员");
            } else {
                comSalaryTempPerMapper.batchInsertSalaryTempPer(comSalaryTemp.getComId(),
                        comSalaryTempId,
                        comSalaryTemp.getCreateBy(),
                        comSalaryTemp.getStartYears(),
                        comSalaryTemp.getEndYears(),
                        perIdList);
            }
        } else {  /*** 修改薪酬模板 ***/
            comSalaryTempMapper.updateComSalaryTemp(comSalaryTemp);

            /*** 薪酬报表对应项目 先删除再插入 ***/
            comSalaryTempProjectMapper.deleteSalaryTempProject(comSalaryTemp.getComSalaryTempId());
            Map<String, ComSalaryTempProject> projectMap = Maps.newHashMap();
            for (String key : requestMap.keySet()) {
                /* 先处理五险一金的项 */
                if (key.endsWith("_five")) {
                    String value = requestMap.get(key);
                    if (CommonConst.N.equals(value)) {
                        continue;
                    }
                }
                if (!(key.endsWith("_amount") || key.endsWith("_remark") || key.endsWith("_five"))) {
                    continue;
                }
                String newKey = CharMatcher.digit().retainFrom(key);
                ComSalaryTempProject project;
                if (projectMap.get(newKey) == null) {
                    project = new ComSalaryTempProject();
                    project.setComSalaryTempId(comSalaryTemp.getComSalaryTempId());
                    project.setCreateTime(comSalaryTemp.getCreateTime());
                    project.setCreateBy(comSalaryTemp.getCreateBy());
                    project.setSalaryType(newKey);
                    project.setSetAmount(0L);
                } else {
                    project = projectMap.get(newKey);
                }
                if (key.endsWith("_amount") && StringUtil.isNotEmpty(requestMap.get(key))) {
                    project.setSetAmount(Long.parseLong(requestMap.get(key)));
                } else if (key.endsWith("_remark")) {
                    project.setRemark(requestMap.get(key));
                }
                projectMap.put(newKey, project);
            }
            if (projectMap.size() > 0) {
                comSalaryTempProjectMapper.batchInsertSalaryTempProject(new ArrayList<>(projectMap.values()));
            }

            /*** 薪酬报表对应人员 先删除再插入 ***/
            comSalaryTempPerMapper.deleteSalaryTempPer(comSalaryTemp.getComSalaryTempId());
            List<String> perIdList = StrSplitter.split(requestMap.get("perList"), ",", true, true);
            if (perIdList.size() == 0) {
                return Result.fail("薪酬模板必须选择人员");
            } else {
                comSalaryTempPerMapper.batchInsertSalaryTempPer(comSalaryTemp.getComId(),
                        comSalaryTemp.getComSalaryTempId(),
                        comSalaryTemp.getCreateBy(),
                        comSalaryTemp.getStartYears(),
                        comSalaryTemp.getEndYears(),
                        perIdList);
            }
        }
        return Result.success("保存成功");
    }

    /**
     * 查询企业薪酬模板列表
     *
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-29
     */
    @Override
    public Result pageComSalaryTemp(ComSalaryTempDTO dto) throws BusinessException {
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<Map<String, Object>> list = comSalaryTempMapper.getComSalaryTempList(dto);
        PageInfoUtils pageInfo = new PageInfoUtils(list);
        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }


    /**
     * 查询企业薪酬模板详情
     *
     * @param temp
     * @return
     * @author llc
     * @date 2018-12-29
     */
    @Override
    public Result getComSalaryTempInfo(ComSalaryTemp temp) throws BusinessException {

        /*** 获取企业薪酬模板 ***/
        ComSalaryTemp comSalaryTemp = comSalaryTempMapper.getComSalaryTempById(temp.getComSalaryTempId());


        List<ConfigSalaryCategoryDTO> categoryList = comSalaryTempMapper.getConfigSalaryCategory();

        /***  获取企业薪酬对应项目列表 ***/
        List<ComSalaryTempProjectDTO> projectList = comSalaryTempProjectMapper.getComSalaryTempProjectList(temp.getComSalaryTempId());

        /*** 把薪资项目放入薪资范畴列表 ***/
        for (ConfigSalaryCategoryDTO dto : categoryList) {
            List<ComSalaryTempProjectDTO> salaryProjectList = new ArrayList<>();
            for (ComSalaryTempProjectDTO salaryType : projectList) {
                if (salaryType.getSalaryCategory().equals(dto.getSalaryCategory())) {
                    salaryProjectList.add(salaryType);
                }
            }
            dto.setSalaryProjectList(salaryProjectList);
        }

        /***  获取企业薪酬对应人员列表 ***/
        List<String> perList = comSalaryTempPerMapper.getComSalaryTempPerList(temp.getComSalaryTempId());

        Map<String, Object> result = new LinkedHashMap<>();
        result.put("comSalaryTemp", comSalaryTemp);
        result.put("categoryList", categoryList);
        result.put("perList", perList);
        return Result.success(Result.SUCCESS_QUERY_MSG, result);
    }

    /**
     * 删除企业薪酬模板
     *
     * @param temp
     * @return
     * @author llc
     * @date 2018-12-29
     */
    @Override
    public Result delComSalaryTemp(ComSalaryTemp temp) throws BusinessException {

        comSalaryTempPerMapper.deleteSalaryTempPer(temp.getComSalaryTempId());

        comSalaryTempProjectMapper.deleteSalaryTempProject(temp.getComSalaryTempId());

        comSalaryTempMapper.delComSalaryTempById(temp.getComSalaryTempId());

        return Result.success("删除成功");
    }


    /**
     * 复制企业薪酬模板(人员不能复制)
     *
     * @param temp
     * @return
     * @author llc
     * @date 2018-12-29
     */
    @Override
    public Result copyComSalaryTemp(ComSalaryTemp temp) throws BusinessException {
        Long ComSalaryTempId = idWorker.nextId();

        /*** 复制薪酬模板 ***/
        comSalaryTempMapper.copySalaryTemp(temp.getComSalaryTempId(), ComSalaryTempId, temp.getCreateBy(), temp.getCreateTime());

        /*** 复制保障项目 ***/
        comSalaryTempProjectMapper.copySalaryTempProject(temp.getComSalaryTempId(), ComSalaryTempId, temp.getCreateBy(), temp.getCreateTime());

        return Result.success("复制成功");
    }

    //public static void main(String[] args) {
    //    ComSalaryTempDTO dto = new ComSalaryTempDTO();
    //    dto.setName("我是模板名称");
    //    dto.setStartYears("2019-01");
    //    dto.setEndYears("2019-10");
    //    dto.setRemark("我是模板备注");
    //    List<String> stringList = Lists.newArrayList("491619615730827264","494090617819758592","494090946783215616");
    //    dto.setPerIdList(stringList);
    //    Map<String,String> map = Maps.newLinkedHashMap();
    //    map.put("1101_amount","10000");
    //    map.put("1101_remark","我是基本工资备注");
    //    map.put("1102_amount","100");
    //    map.put("1102_remark","我是绩效工资备注");
    //    dto.setSalaryProjectMap(map);
    //
    //    Map<String,String> map2 = Maps.newLinkedHashMap();
    //    map2.put("1401","1");
    //    map2.put("1402","0");
    //    map2.put("1403","1");
    //    map2.put("1408","1");
    //    map2.put("1501","1");
    //    dto.setFiveProjectMap(map2);
    //
    //    Console.log(JSON.toJSONString(dto));
    //}
}