package com.bcxin.oa.old.service.attend;

import com.bcxin.oa.old.dto.ComAttendAddressDTO;
import com.bcxin.oa.old.dto.ComAttendGroupDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

/**
 * 企业考勤组
 *
 * @author zhangye
 * @since 2018-02-26 10:47:41
 */
public interface ComAttendGroupService {

    /**
     * 考勤组分页
     *
     * @param comAttendGroupDTO
     * @return
     * @author zhongjianhui
     * @since 2018-02-28
     */
    Result pageForGroup(ComAttendGroupDTO comAttendGroupDTO) ;


    /**
     *
     *  进入考勤设置第一步页面
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-30
     */
    Result inFirstStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException ;

    /**
     *
     *  进入考勤设置第二步页面
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-30
     */
    Result inSecondStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException ;


    /**
     *
     *  进入考勤设置第三步页面
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-30
     */
     Result inThirdStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException ;



    /**
     * 考勤中间表暂存第一步 (设置考勤类型和工作安排)
     *
     * @param comAttendGroupDto
     * @return
     * @author llc
     * @since 2018-03-27
     */
    Result saveFirstStepAttendGroup(ComAttendGroupDTO comAttendGroupDto) throws BusinessException ;


    /**
     * 校验考勤组人员
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-28
     */
     Result saveSecondStepAttendGroup(ComAttendAddressDTO dto) throws BusinessException ;



    /**
     * 考勤中间表暂存第二步 (设置考勤方式)
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-29
     */

     Result checkAttendPer(ComAttendGroupDTO dto) throws BusinessException ;


    /**
     * 考勤中间表暂存第三步 (设置考勤人员)
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-28
     */
    Result saveThirdStepAttendGroup(ComAttendGroupDTO dto)  throws BusinessException;



    /**
     * 定时器删除正式考勤组修改的考勤组中间表、考勤组人员校验表（最后一步未提交）
     *
     * @param
     * @return
     * @author llc
     * @since 2018-04-02
     */
     Result  deleteMidAttendByTask();


    /**
     * 删除考勤组
     *
     * @param comAttendGroupDTO
     * @return
     * @author wuxiaozhen
     * @since 2018-03-01
     */
    Result delete(ComAttendGroupDTO comAttendGroupDTO) throws BusinessException;



    /**
     * 内勤打卡提醒定时器
     *
     * @return
     * @author llc
     * @date 2019-01-10
     */
    Result attendCardRemindJob() throws BusinessException;

}