package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ValidateTaskFixed;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 固定任务校验表
 *
 * @author zhangye
 * @since 2018-03-26 17:48:45
 */
public interface ValidateTaskFixedMapper extends CrudDao<ValidateTaskFixed> {

    /**
     * 批量插入固定任务校验表
     *
     * @param listValidateTaskFixed
     * @return
     */
    int insertValidateTaskFixedList(List<ValidateTaskFixed> listValidateTaskFixed);

    /**
     * 批量插入固定任务校验表，天为单位
     * @param list
     * @return
     */
    int insertValidateTaskFixedDateList(@Param("list") List<ValidateTaskFixed> list,
                                        @Param("comId") Long comId,
                                        @Param("attendType") String attendType,
                                        @Param("dates") String dates,
                                        @Param("midTaskId") Long midTaskId);



    /**
     * 校验人员固定排班是否冲突,返回冲突的排班信息
     *
     * @param startDate
     * @param endDate
     * @param midTaskId
     * @return
     */
    List<Map> checkImplement(@Param("startDate")String startDate, @Param("endDate")String endDate,@Param("midTaskId") Long midTaskId);

    /**
     * 根据ID数组查询人员名称
     *
     * @param list
     * @return
     */
    List<String> listName(List<Long> list);


    /**
     * 校验人员排班冲突（只校验到天）返回冲突的排班信息
     * @param comId
     * @param comTaskId
     * @param midTaskId
     * @return
     */
    List<String> checkPerTaskConflict(@Param("comId")Long comId, @Param("comTaskId")Long comTaskId,@Param("midTaskId") Long midTaskId);
}