package com.bcxin.oa.old.mapper;


import com.bcxin.oa.old.common.CrudDao;
import com.bcxin.oa.old.dto.PerInfoExcelBean;
import com.bcxin.oa.old.dto.PerOrgRelationDto;
import com.bcxin.oa.old.dto.PerOrgRelationInfoDto;
import com.bcxin.oa.old.entity.system.PerBaseInfo;
import com.bcxin.oa.old.entity.system.PerOrgRelation;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 人员组织关系
 *
 * @author zhangye
 * @since 2017-12-22 16:35:48
 */
public interface PerOrgRelationMapper extends CrudDao<PerOrgRelation> {
    /**
     * 通过部门ID获取部门人员关联表的数据
     *
     * @return List<Map>
     * @Decription:
     * @author：zhongjianhui
     * @method selectePerOrgRelationByDepartId
     * @date：2017/12/23 14:12
     * @params： * @param
     * departId
     */
    List<Map> selectePerOrgRelationByDepartId(@Param(value = "orgId") Long orgId,@Param(value = "comId") Long comId);


    /**
     * 获取指定的部门人员关系表数据
     *
     * @return PerOrgRelation
     * @Decription:
     * @author：wangjianchi
     * @method get
     * @date：2018/1/17 14:12
     * @params： * @param
     * departId
     */
    PerOrgRelation get(PerOrgRelation perOrgRelation);

    /**
     * @Author: wuxiaozhen
     * @Description:查询用户任职公司
     * @Date: 2018/03/09 13:58
     */
    PerOrgRelation findNowJob(@Param(value = "perId") Long perId);

    PerOrgRelation findByTlkId(@Param(value = "tlkId") String tlkId);

    /**
     * 查询出个人所有职业经历
     * @param perBaseInfo
     * @return
     */
    List<PerOrgRelationInfoDto> findAllJob(PerBaseInfo perBaseInfo);


    /**
     * @Author: zhongjianhui
     * @Description:查询所有的离职人员
     * @Date: 2017/12/29  11:18
     */
    List<Map> pageLeavePer(PerOrgRelationDto perOrgRelationDto);

    /**
     * 导出组织架构Excel
     *
     * @param comId
     * @return
     */
    List<PerInfoExcelBean> exportDepart(Long comId);

    /**
     * 查询人员现在所在组织关系
     * @param perId
     * @param comId
     * @return
     * update by llc
     * @date 2019-07-25
     */
    PerOrgRelation getByPerIdAndComId(@Param(value = "perId") Long perId,@Param(value = "comId") Long comId);


    /**
     * 获取组织架构人员列表(app)
     * @param perOrgRelation
     * @return
     * @author llc
     * @date 2018-10-30
     */
    List<Map<String,Object>> getPerListByOrg(PerOrgRelation perOrgRelation);


    /**
     * 获取组织架构人员列表(html)
     * @param perOrgRelation
     * @return
     * @author llc
     * @date 2019-03-26
     */
    List<Map<String,Object>> getHtmlPerListByOrg(PerOrgRelation perOrgRelation);


    /**
     * app 审批通过姓名或者手机号码搜索人员信息
     * @param comId
     * @param perId
     * @param keyword
     * @return
     * @author llc
     * @date 2018-10-30
     */
    List<Map<String,Object>> seachPerListByKeyword(@Param(value = "comId") Long comId ,@Param(value = "perId") Long perId ,@Param(value = "keyword") String keyword );


    /**
     * (html) 通过姓名或者手机号码搜索人员信息
     * @param comId
     * @param keyword
     * @return
     * @author llc
     * @date 2019-03-26
     */
    List<Map<String,Object>> seachHtmlPerListByKeyword(@Param(value = "comId") Long comId ,
                                                       @Param(value = "keyword") String keyword ,
                                                       @Param(value = "perId") Long perId,
                                                       @Param("departIdList") List<Long> departIdList);

    /**
     * 删除人员组织关系信息（目前使用场景:陕西关系迁移初始化绑定管理员校验）
     *
     * @param perId
     * @return
     * @author llc
     * @date 2019-03-06
     */
    int deleteByPerId(@Param("perId") Long perId);


    /**
     * 通过人员ID列表查询人员基础信息
     * @param comId
     * @param perIdList
     * @return
     * @author llc
     * @date 2020-04-15
     */
    List<Map<String,String>> getPerBaseInfoListByPerIds(@Param(value = "comId") Long comId ,@Param("perIdList") List<String> perIdList);


    /**
     * 获取组织架构人员列表(web)
     * @param perOrgRelation
     * @return
     * @author llc
     * @date 2019-07-11
     */
    List<Map<String,Object>> getWebPerListByOrg(PerOrgRelation perOrgRelation);


    /**
     * web通过姓名/手机号码/身份证搜索人员信息
     * @param comId
     * @param keyWord
     * @param dataAuthType
     * @param orgIdList
     * @return
     * @author llc
     * @date 2019-07-17
     */
    List<Map<String,String>> getWebPerListByKeyword(@Param("comId") Long comId,@Param("keyWord") String keyWord,@Param("dataAuthType") String dataAuthType,@Param("orgIdList") List<Long> orgIdList);


    /**
     * 公共选人的接口(关键字查询)
     * @param comId
     * @param keyWord
     * @return
     * @author llc
     * @date 2019-08-28
     */
    List<Map<String,String>> getCommonPerListByKeyword(@Param("comId") Long comId,@Param("keyWord") String keyWord);


    /**
     * 驻勤模块选人的接口(关键字查询)
     * @param comId
     * @param keyWord
     * @return
     * @author llc
     * @date 2020-04-16
     */
    List<Map<String,String>> getTaskPerListByKeyword(@Param("comId") Long comId,@Param("keyWord") String keyWord,@Param("dataAuthType") String dataAuthType,@Param("orgIdList") List<Long> orgIdList);

    /**
     * 查询企业人数
     * @param comId
     * @return
     * @author llc
     * @date 2019-07-11
     */
    Map<String,Object> getComPerCount(@Param("comId") Long comId);

    /**
     * 获取选人公共部门树的人员列表
     * @param perOrgRelation
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    List<Map<String,Object>> getDepartPerSonList(PerOrgRelation perOrgRelation);



    /**
     * 获取驻勤模块公共部门树的人员列表
     * @param perOrgRelation
     * @auth llc
     * @date 2020-04-16
     * @return
     */
    List<Map<String,Object>> getTaskDepartPerSonList(PerOrgRelation perOrgRelation);


    /**
     * 获取华为会议选人公共部门树的人员列表
     * @param perOrgRelation
     * @auth llc
     * @date 2019-12-12
     * @return
     */
    List<Map<String,Object>> getHuaweiDepartPerSonList(PerOrgRelation perOrgRelation);


    /**
     * 华为会议选人的接口(关键字查询)
     * @param comId
     * @param keyWord
     * @return
     * @author llc
     * @date 2019-12-12
     */
    List<Map<String,String>> getHuaweiPerListByKeyword(@Param("comId") Long comId,@Param("keyWord") String keyWord);
}