package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskFixed;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 任务固定班制明细
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
public interface ComTaskFixedMapper extends CrudDao<ComTaskFixed> {

    /**
     * 根据任务ID查询固定周期任务
     *
     * @param comTaskId
     * @return
     */
    List<ComTaskFixed> listComTaskFixedById(Long comTaskId);

    /**
     * 查询固定排班信息
     * @param comTaskFixed1
     * @return
     */
    List<ComTaskFixed> listComTaskFixed(ComTaskFixed comTaskFixed1);


    /**
     * 批量更新固定班次
     * @param list
     * @return
     * by llc 2018-09-27
     */
    int batchUpdateComTaskFixed(@Param("list") List<ComTaskFixed> list);


    /**
     * 批量新增固定班次
     * @param list
     * @return
     * by llc 2018-09-27
     */
    int batchInsertComTaskFixed(@Param("list") List<ComTaskFixed> list);

    //批量删除驻勤点
    //删除任务代班申请
    int deleteApproveTaskAdjustApply(@Param("list") List<Long> list);
    //删除任务请假申请
    int deleteApproveTaskLeaveApply(@Param("list") List<Long> list);
    //任务补卡申请
    int deleteApproveTaskRemedyApply(@Param("list") List<Long> list);
    //任务审批关联表
    int deleteComTaskApprove(@Param("list") List<Long> list);
    //任务考勤地址
    int deleteComTaskAttendAddress(@Param("list") List<Long> list);
    //任务考勤WIFI
    int deleteComTaskAttendWifi(@Param("list") List<Long> list);
    //任务代班记录
    int deleteComTaskBehalf(@Param("list") List<Long> list);
    //企业考勤地址
    int deleteComTaskChargeRecord(@Param("list") List<Long> list);
    //任务合同关联
    int deleteComTaskContract(@Param("list") List<Long> list);
    //任务反馈记录
    int deleteComTaskFeedback(@Param("list") List<Long> list);
    //任务固定班制明细
    int deleteComTaskFixed(@Param("list") List<Long> list);
    //任务自由工时明细
    int deleteComTaskFree(@Param("list") List<Long> list);
    //任务执行情况表
    int deleteComTaskImplement(@Param("list") List<Long> list);
    //任务内部推送
    int deleteComTaskInsidePush(@Param("list") List<Long> list);
    //任务班次选择校验中间表
    int deleteComTaskMidControl(@Param("list") List<Long> list);
    //任务操作流程
    int deleteComTaskOperProcess(@Param("list") List<Long> list);
    //删除任务增援记录
    int deleteComTaskReinforce(@Param("list") List<Long> list);
    //删除任务排班制明细
    int deleteComTaskSchedul(@Param("list") List<Long> list);
    //删除任务排班周期
    int deleteComTaskSchedulCycle(@Param("list") List<Long> list);
    //删除任务班次范围（排班）
    int deleteComTaskShift(@Param("list") List<Long> list);
    //删除人员外勤审批日统计表
    int deleteCountPerTaskApproveDate(@Param("list") List<Long> list);
    //删除人员外勤日统计表
    int deleteCountPerTaskDate(@Param("list") List<Long> list);
    //删除任务打卡记录
    int deletePerTaskCardRecord(@Param("list") List<Long> list);
    //删除外勤打卡提醒
    int deleteTaskCardRemind(@Param("list") List<Long> list);
    //删除任务
    int deleteTask(@Param("list") List<Long> list);
    //删除任务通知发送人员
    int deleteTaskMessagePer(@Param("list") List<Long> list);
    //删除任务通知
    int deleteTaskMessage(@Param("list") List<Long> list);


















}