package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.system.ComSocialInsScheme;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>陈堂君
 * <p>类描述: 企业医社保缴费方案
 * <p>
 * @apiNote  作者 陈堂君
 * @since 创建于 2017/12/22 13:11
 */
@Component
public interface ComSocialInsSchemeMapper {
    /**
     * 根据ID，获得缴交方案详情
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 10:59
     * @param paySchemeId
     * @return
     */
    ComSocialInsScheme selectById(@Param("paySchemeId") Long paySchemeId);

    /**
     *  根据企业ID，查询企业信息，可以判断方案是否过期
     * @apiNote  作者 陈堂君  
     * @since 创建于 2018/1/10 11:00
     * @param comId
     * @param queryExpired
     * @return
     */
    List<ComSocialInsScheme> selectByComId(@Param("comId") Long comId , @Param("queryExpired") String queryExpired);

    /**
     * 批量删除多个方案
     * @apiNote  作者 陈堂君  
     * @since 创建于 2018/1/10 11:03
     * @param paySchemeIds
     * @return
     */
    int deleteByIds(@Param("paySchemeIds") String paySchemeIds);

    int insert(ComSocialInsScheme record);
    int update(ComSocialInsScheme record);
}