package com.bcxin.oa.old.entity.task.tempTask;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 企业临保任务班次规则
 * 
 * @author llc
 * @date 2020-02-21
 */
@Data
@TableName("com_temp_task_shift_rule")
public class ComTempTaskShiftRule extends BaseEntity<ComTempTaskShiftRule> {

	/** 班次规则ID */
	@ApiModelProperty(value = "班次规则ID")
	private Long shiftRuleId;


	/** 上下班第几轮 */
	@ApiModelProperty(value = "上下班第几轮")
	private int commutRound;

	/** 上班时间 */
	@ApiModelProperty(value = "上班时间")
	private Date startWorkTime;

	/** 下班时间 */
	@ApiModelProperty(value = "下班时间")
	private Date endWorkTime;


	/** 上班时间是否是次日 */
	@ApiModelProperty(value = "上班时间是否是次日")
	private String isStartNextDay;

	/** 下班时间是否是次日 */
	@ApiModelProperty(value = "下班时间是否是次日")
	private String isEndNextDay;

	/** 班次ID */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftRuleId() {
		return shiftRuleId;
	}

	@Override
	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComId() {
		return comId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

	@JsonFormat(pattern = "HH:mm:ss")
	public Date getStartWorkTime() {
		return startWorkTime;
	}

	@JsonFormat(pattern = "HH:mm:ss")
	public Date getEndWorkTime() {
		return endWorkTime;
	}

}