package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 任务班次范围（排班）
 *
 * @author zhangye
 * @since 2018-02-26 10:42:16
 */
@Data
@TableName("com_task_shift")
public class ComTaskShift extends BaseEntity<ComTaskShift> {
    private static final long serialVersionUID = 1359285006L;

    /**
     * 企业ID
     */
    @ApiModelProperty(value = "企业ID")
    private Long comId;

    /**
     * 任务ID
     */
    @ApiModelProperty(value = "任务ID")
    private Long comTaskId;

    /**
     * 班次ID
     */
    @ApiModelProperty(value = "班次ID")
    private Long shiftId;


    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComTaskId() {
        return comTaskId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getShiftId() {
        return shiftId;
    }

}