package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 任务排班周期
 * 
 * @author zhangye
 * @since 2018-02-26 10:42:16
 */
@Data
@TableName("com_task_schedul_cycle")
public class ComTaskSchedulCycle extends BaseEntity<ComTaskSchedulCycle> {
	private static final long serialVersionUID = 1728716779L;

	/** 任务排班周期ID */
	@ApiModelProperty(value = "任务排班周期ID")
	private Long taskSchedulCycleId;

	/** 企业ID */
	@ApiModelProperty(value = "企业ID")
	private Long comId;

	/** 周期名称 */
	@ApiModelProperty(value = "周期名称")
	private String cycleName;

	/** 周期天数 */
	@ApiModelProperty(value = "周期天数")
	private int cycleDays;

	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long comTaskId;

	/** 开始日期 */
	@ApiModelProperty(value = "开始日期")
	private Date startDate;

	/** 截止日期 */
	@ApiModelProperty(value = "截止日期")
	private Date endDate;

	/** 人员ID集合 */
	@ApiModelProperty(value = "人员ID集合")
	private String perIds;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getTaskSchedulCycleId() {
		return taskSchedulCycleId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComTaskId() {
		return comTaskId;
	}

}